/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

/**
 * A transformation that asserts which transformations happen next.
 * <p>
 * This transformation checks whether the camel-case names (i.e. "FlatMap", not
 * "flat_map") of the transformations following this transformation match the list
 * of names in the `transformations` argument. If there is a mismatch, the
 * transformation raises an exception.
 * <p>
 * The check occurs when iterating over the contents of the dataset, which
 * means that the check happens <i>after</i> any static optimizations are applied
 * to the dataset graph.
 */
public final class AssertNextDataset extends PrimitiveOp implements Operand<Object> {
  
  /**
   * Factory method to create a class wrapping a new AssertNextDataset operation.
   * 
   * @param scope current scope
   * @param inputDataset A variant tensor representing the input dataset.
   * `AssertNextDataset` passes through the outputs of its input dataset.
   * @param transformations A `tf.string` vector `tf.Tensor` identifying the transformations that are
   * expected to happen next.
   * @param outputTypes 
   * @param outputShapes 
   * @return a new instance of AssertNextDataset
   */
  public static AssertNextDataset create(Scope scope, Operand<?> inputDataset, Operand<String> transformations, List<Class<?>> outputTypes, List<Shape> outputShapes) {
    OperationBuilder opBuilder = scope.env().opBuilder("AssertNextDataset", scope.makeOpName("AssertNextDataset"));
    opBuilder.addInput(inputDataset.asOutput());
    opBuilder.addInput(transformations.asOutput());
    opBuilder = scope.applyControlDependencies(opBuilder);
    DataType[] outputTypesArray = new DataType[outputTypes.size()];
    for (int i = 0; i < outputTypesArray.length; ++i) {
      outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
    }
    opBuilder.setAttr("output_types", outputTypesArray);
    Shape[] outputShapesArray = new Shape[outputShapes.size()];
    for (int i = 0; i < outputShapesArray.length; ++i) {
      outputShapesArray[i] = outputShapes.get(i);
    }
    opBuilder.setAttr("output_shapes", outputShapesArray);
    return new AssertNextDataset(opBuilder.build());
  }
  
  /**
   */
  public Output<?> handle() {
    return handle;
  }
  
  @Override
  @SuppressWarnings("unchecked")
  public Output<Object> asOutput() {
    return (Output<Object>) handle;
  }
  
  private Output<?> handle;
  
  private AssertNextDataset(Operation operation) {
    super(operation);
    int outputIdx = 0;
    handle = operation.output(outputIdx++);
  }
}
