/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.Shape;
import org.tensorflow.op.Scope;
import org.tensorflow.op.sparse.AddManySparseToTensorsMap;
import org.tensorflow.op.sparse.AddSparseToTensorsMap;
import org.tensorflow.op.sparse.DenseToDenseSetOperation;
import org.tensorflow.op.sparse.DenseToSparseSetOperation;
import org.tensorflow.op.sparse.DeserializeSparse;
import org.tensorflow.op.sparse.SparseAccumulatorApplyGradient;
import org.tensorflow.op.sparse.SparseAccumulatorTakeGradient;
import org.tensorflow.op.sparse.SparseAdd;
import org.tensorflow.op.sparse.SparseAddGrad;
import org.tensorflow.op.sparse.SparseConcat;
import org.tensorflow.op.sparse.SparseConditionalAccumulator;
import org.tensorflow.op.sparse.SparseCross;
import org.tensorflow.op.sparse.SparseDenseCwiseAdd;
import org.tensorflow.op.sparse.SparseDenseCwiseDiv;
import org.tensorflow.op.sparse.SparseDenseCwiseMul;
import org.tensorflow.op.sparse.SparseFillEmptyRows;
import org.tensorflow.op.sparse.SparseFillEmptyRowsGrad;
import org.tensorflow.op.sparse.SparseMatMul;
import org.tensorflow.op.sparse.SparseReduceMax;
import org.tensorflow.op.sparse.SparseReduceMaxSparse;
import org.tensorflow.op.sparse.SparseReduceSum;
import org.tensorflow.op.sparse.SparseReduceSumSparse;
import org.tensorflow.op.sparse.SparseReorder;
import org.tensorflow.op.sparse.SparseReshape;
import org.tensorflow.op.sparse.SparseSegmentMean;
import org.tensorflow.op.sparse.SparseSegmentMeanGrad;
import org.tensorflow.op.sparse.SparseSegmentMeanWithNumSegments;
import org.tensorflow.op.sparse.SparseSegmentSqrtN;
import org.tensorflow.op.sparse.SparseSegmentSqrtNGrad;
import org.tensorflow.op.sparse.SparseSegmentSqrtNWithNumSegments;
import org.tensorflow.op.sparse.SparseSegmentSum;
import org.tensorflow.op.sparse.SparseSegmentSumWithNumSegments;
import org.tensorflow.op.sparse.SparseSlice;
import org.tensorflow.op.sparse.SparseSliceGrad;
import org.tensorflow.op.sparse.SparseSoftmax;
import org.tensorflow.op.sparse.SparseSparseMaximum;
import org.tensorflow.op.sparse.SparseSparseMinimum;
import org.tensorflow.op.sparse.SparseSplit;
import org.tensorflow.op.sparse.SparseTensorDenseAdd;
import org.tensorflow.op.sparse.SparseTensorDenseMatMul;
import org.tensorflow.op.sparse.SparseToDense;
import org.tensorflow.op.sparse.SparseToSparseSetOperation;
import org.tensorflow.op.sparse.TakeManySparseFromTensorsMap;

public final class SparseOps {
    private final Scope scope;

    SparseOps(Scope scope) {
        this.scope = scope;
    }

    public <T> SparseReorder<T> sparseReorder(Operand<Long> inputIndices, Operand<T> inputValues, Operand<Long> inputShape) {
        return SparseReorder.create(this.scope, inputIndices, inputValues, inputShape);
    }

    public <T extends Number, U extends Number> SparseSegmentSqrtNGrad<T> sparseSegmentSqrtNGrad(Operand<T> grad, Operand<U> indices, Operand<Integer> segmentIds, Operand<Integer> outputDim0) {
        return SparseSegmentSqrtNGrad.create(this.scope, grad, indices, segmentIds, outputDim0);
    }

    public <T> SparseAccumulatorApplyGradient sparseAccumulatorApplyGradient(Operand<String> handle, Operand<Long> localStep, Operand<Long> gradientIndices, Operand<T> gradientValues, Operand<Long> gradientShape, Boolean hasKnownShape) {
        return SparseAccumulatorApplyGradient.create(this.scope, handle, localStep, gradientIndices, gradientValues, gradientShape, hasKnownShape);
    }

    public <T> SparseFillEmptyRows<T> sparseFillEmptyRows(Operand<Long> indices, Operand<T> values, Operand<Long> denseShape, Operand<T> defaultValue) {
        return SparseFillEmptyRows.create(this.scope, indices, values, denseShape, defaultValue);
    }

    public <T extends Number, U extends Number> SparseSegmentSqrtN<T> sparseSegmentSqrtN(Operand<T> data, Operand<U> indices, Operand<Integer> segmentIds) {
        return SparseSegmentSqrtN.create(this.scope, data, indices, segmentIds);
    }

    public <U, T extends Number> SparseTensorDenseAdd<U> sparseTensorDenseAdd(Operand<T> aIndices, Operand<U> aValues, Operand<T> aShape, Operand<U> b) {
        return SparseTensorDenseAdd.create(this.scope, aIndices, aValues, aShape, b);
    }

    public <U, T extends Number> SparseTensorDenseMatMul<U> sparseTensorDenseMatMul(Operand<T> aIndices, Operand<U> aValues, Operand<Long> aShape, Operand<U> b, SparseTensorDenseMatMul.Options ... options) {
        return SparseTensorDenseMatMul.create(this.scope, aIndices, aValues, aShape, b, options);
    }

    public <U, T> DeserializeSparse<U> deserializeSparse(Operand<T> serializedSparse, Class<U> dtype) {
        return DeserializeSparse.create(this.scope, serializedSparse, dtype);
    }

    public <T extends Number, U extends Number, V extends Number> SparseSegmentSqrtNWithNumSegments<T> sparseSegmentSqrtNWithNumSegments(Operand<T> data, Operand<U> indices, Operand<Integer> segmentIds, Operand<V> numSegments) {
        return SparseSegmentSqrtNWithNumSegments.create(this.scope, data, indices, segmentIds, numSegments);
    }

    public <T> TakeManySparseFromTensorsMap<T> takeManySparseFromTensorsMap(Operand<Long> sparseHandles, Class<T> dtype, TakeManySparseFromTensorsMap.Options ... options) {
        return TakeManySparseFromTensorsMap.create(this.scope, sparseHandles, dtype, options);
    }

    public <T extends Number> SparseReduceMaxSparse<T> sparseReduceMaxSparse(Operand<Long> inputIndices, Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes, SparseReduceMaxSparse.Options ... options) {
        return SparseReduceMaxSparse.create(this.scope, inputIndices, inputValues, inputShape, reductionAxes, options);
    }

    public <T> AddSparseToTensorsMap addSparseToTensorsMap(Operand<Long> sparseIndices, Operand<T> sparseValues, Operand<Long> sparseShape, AddSparseToTensorsMap.Options ... options) {
        return AddSparseToTensorsMap.create(this.scope, sparseIndices, sparseValues, sparseShape, options);
    }

    public <T, U extends Number> SparseAdd<T> sparseAdd(Operand<Long> aIndices, Operand<T> aValues, Operand<Long> aShape, Operand<Long> bIndices, Operand<T> bValues, Operand<Long> bShape, Operand<U> thresh) {
        return SparseAdd.create(this.scope, aIndices, aValues, aShape, bIndices, bValues, bShape, thresh);
    }

    public <T extends Number, U extends Number> SparseSegmentMeanGrad<T> sparseSegmentMeanGrad(Operand<T> grad, Operand<U> indices, Operand<Integer> segmentIds, Operand<Integer> outputDim0) {
        return SparseSegmentMeanGrad.create(this.scope, grad, indices, segmentIds, outputDim0);
    }

    public <T extends Number, U extends Number> SparseMatMul sparseMatMul(Operand<T> a, Operand<U> b, SparseMatMul.Options ... options) {
        return SparseMatMul.create(this.scope, a, b, options);
    }

    public <T> SparseFillEmptyRowsGrad<T> sparseFillEmptyRowsGrad(Operand<Long> reverseIndexMap, Operand<T> gradValues) {
        return SparseFillEmptyRowsGrad.create(this.scope, reverseIndexMap, gradValues);
    }

    public <T> SparseDenseCwiseDiv<T> sparseDenseCwiseDiv(Operand<Long> spIndices, Operand<T> spValues, Operand<Long> spShape, Operand<T> dense) {
        return SparseDenseCwiseDiv.create(this.scope, spIndices, spValues, spShape, dense);
    }

    public <T> SparseSlice<T> sparseSlice(Operand<Long> indices, Operand<T> values, Operand<Long> shape, Operand<Long> start, Operand<Long> size) {
        return SparseSlice.create(this.scope, indices, values, shape, start, size);
    }

    public <T> SparseReduceSumSparse<T> sparseReduceSumSparse(Operand<Long> inputIndices, Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes, SparseReduceSumSparse.Options ... options) {
        return SparseReduceSumSparse.create(this.scope, inputIndices, inputValues, inputShape, reductionAxes, options);
    }

    public <T> SparseReduceSum<T> sparseReduceSum(Operand<Long> inputIndices, Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes, SparseReduceSum.Options ... options) {
        return SparseReduceSum.create(this.scope, inputIndices, inputValues, inputShape, reductionAxes, options);
    }

    public <T extends Number, U extends Number, V extends Number> SparseSegmentSumWithNumSegments<T> sparseSegmentSumWithNumSegments(Operand<T> data, Operand<U> indices, Operand<Integer> segmentIds, Operand<V> numSegments) {
        return SparseSegmentSumWithNumSegments.create(this.scope, data, indices, segmentIds, numSegments);
    }

    public <T> SparseSparseMinimum<T> sparseSparseMinimum(Operand<Long> aIndices, Operand<T> aValues, Operand<Long> aShape, Operand<Long> bIndices, Operand<T> bValues, Operand<Long> bShape) {
        return SparseSparseMinimum.create(this.scope, aIndices, aValues, aShape, bIndices, bValues, bShape);
    }

    public <T> AddManySparseToTensorsMap addManySparseToTensorsMap(Operand<Long> sparseIndices, Operand<T> sparseValues, Operand<Long> sparseShape, AddManySparseToTensorsMap.Options ... options) {
        return AddManySparseToTensorsMap.create(this.scope, sparseIndices, sparseValues, sparseShape, options);
    }

    public <T extends Number, U extends Number> SparseSegmentMean<T> sparseSegmentMean(Operand<T> data, Operand<U> indices, Operand<Integer> segmentIds) {
        return SparseSegmentMean.create(this.scope, data, indices, segmentIds);
    }

    public <T> SparseToSparseSetOperation<T> sparseToSparseSetOperation(Operand<Long> set1Indices, Operand<T> set1Values, Operand<Long> set1Shape, Operand<Long> set2Indices, Operand<T> set2Values, Operand<Long> set2Shape, String setOperation, SparseToSparseSetOperation.Options ... options) {
        return SparseToSparseSetOperation.create(this.scope, set1Indices, set1Values, set1Shape, set2Indices, set2Values, set2Shape, setOperation, options);
    }

    public <T> DenseToSparseSetOperation<T> denseToSparseSetOperation(Operand<T> set1, Operand<Long> set2Indices, Operand<T> set2Values, Operand<Long> set2Shape, String setOperation, DenseToSparseSetOperation.Options ... options) {
        return DenseToSparseSetOperation.create(this.scope, set1, set2Indices, set2Values, set2Shape, setOperation, options);
    }

    public <T> SparseSplit<T> sparseSplit(Operand<Long> splitDim, Operand<Long> indices, Operand<T> values, Operand<Long> shape, Long numSplit) {
        return SparseSplit.create(this.scope, splitDim, indices, values, shape, numSplit);
    }

    public <T> DenseToDenseSetOperation<T> denseToDenseSetOperation(Operand<T> set1, Operand<T> set2, String setOperation, DenseToDenseSetOperation.Options ... options) {
        return DenseToDenseSetOperation.create(this.scope, set1, set2, setOperation, options);
    }

    public <T> SparseAccumulatorTakeGradient<T> sparseAccumulatorTakeGradient(Operand<String> handle, Operand<Integer> numRequired, Class<T> dtype) {
        return SparseAccumulatorTakeGradient.create(this.scope, handle, numRequired, dtype);
    }

    public <T> SparseDenseCwiseMul<T> sparseDenseCwiseMul(Operand<Long> spIndices, Operand<T> spValues, Operand<Long> spShape, Operand<T> dense) {
        return SparseDenseCwiseMul.create(this.scope, spIndices, spValues, spShape, dense);
    }

    public <T> SparseConditionalAccumulator sparseConditionalAccumulator(Class<T> dtype, Shape shape, SparseConditionalAccumulator.Options ... options) {
        return SparseConditionalAccumulator.create(this.scope, dtype, shape, options);
    }

    public <T extends Number> SparseReduceMax<T> sparseReduceMax(Operand<Long> inputIndices, Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes, SparseReduceMax.Options ... options) {
        return SparseReduceMax.create(this.scope, inputIndices, inputValues, inputShape, reductionAxes, options);
    }

    public <T> SparseDenseCwiseAdd<T> sparseDenseCwiseAdd(Operand<Long> spIndices, Operand<T> spValues, Operand<Long> spShape, Operand<T> dense) {
        return SparseDenseCwiseAdd.create(this.scope, spIndices, spValues, spShape, dense);
    }

    public <U, T extends Number> SparseToDense<U> sparseToDense(Operand<T> sparseIndices, Operand<T> outputShape, Operand<U> sparseValues, Operand<U> defaultValue, SparseToDense.Options ... options) {
        return SparseToDense.create(this.scope, sparseIndices, outputShape, sparseValues, defaultValue, options);
    }

    public <T, U> SparseCross<T> sparseCross(Iterable<Operand<Long>> indices, Iterable<Operand<?>> values, Iterable<Operand<Long>> shapes, Iterable<Operand<?>> denseInputs, Boolean hashedOutput, Long numBuckets, Long hashKey, Class<T> outType, Class<U> internalType) {
        return SparseCross.create(this.scope, indices, values, shapes, denseInputs, hashedOutput, numBuckets, hashKey, outType, internalType);
    }

    public <T> SparseSliceGrad<T> sparseSliceGrad(Operand<T> backpropValGrad, Operand<Long> inputIndices, Operand<Long> inputStart, Operand<Long> outputIndices) {
        return SparseSliceGrad.create(this.scope, backpropValGrad, inputIndices, inputStart, outputIndices);
    }

    public <T extends Number, U extends Number, V extends Number> SparseSegmentMeanWithNumSegments<T> sparseSegmentMeanWithNumSegments(Operand<T> data, Operand<U> indices, Operand<Integer> segmentIds, Operand<V> numSegments) {
        return SparseSegmentMeanWithNumSegments.create(this.scope, data, indices, segmentIds, numSegments);
    }

    public <T> SparseAddGrad<T> sparseAddGrad(Operand<T> backpropValGrad, Operand<Long> aIndices, Operand<Long> bIndices, Operand<Long> sumIndices) {
        return SparseAddGrad.create(this.scope, backpropValGrad, aIndices, bIndices, sumIndices);
    }

    public <T extends Number> SparseSoftmax<T> sparseSoftmax(Operand<Long> spIndices, Operand<T> spValues, Operand<Long> spShape) {
        return SparseSoftmax.create(this.scope, spIndices, spValues, spShape);
    }

    public <T> SparseConcat<T> sparseConcat(Iterable<Operand<Long>> indices, Iterable<Operand<T>> values, Iterable<Operand<Long>> shapes, Long concatDim) {
        return SparseConcat.create(this.scope, indices, values, shapes, concatDim);
    }

    public <T extends Number> SparseSparseMaximum<T> sparseSparseMaximum(Operand<Long> aIndices, Operand<T> aValues, Operand<Long> aShape, Operand<Long> bIndices, Operand<T> bValues, Operand<Long> bShape) {
        return SparseSparseMaximum.create(this.scope, aIndices, aValues, aShape, bIndices, bValues, bShape);
    }

    public <T extends Number, U extends Number> SparseSegmentSum<T> sparseSegmentSum(Operand<T> data, Operand<U> indices, Operand<Integer> segmentIds) {
        return SparseSegmentSum.create(this.scope, data, indices, segmentIds);
    }

    public SparseReshape sparseReshape(Operand<Long> inputIndices, Operand<Long> inputShape, Operand<Long> newShape) {
        return SparseReshape.create(this.scope, inputIndices, inputShape, newShape);
    }
}

