/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class NonMaxSuppressionV5<T extends Number>
extends PrimitiveOp {
    private Output<Integer> selectedIndices;
    private Output<T> selectedScores;
    private Output<Integer> validOutputs;

    public static <T extends Number> NonMaxSuppressionV5<T> create(Scope scope, Operand<T> boxes, Operand<T> scores, Operand<Integer> maxOutputSize, Operand<T> iouThreshold, Operand<T> scoreThreshold, Operand<T> softNmsSigma, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("NonMaxSuppressionV5", scope.makeOpName("NonMaxSuppressionV5"));
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(maxOutputSize.asOutput());
        opBuilder.addInput(iouThreshold.asOutput());
        opBuilder.addInput(scoreThreshold.asOutput());
        opBuilder.addInput(softNmsSigma.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.padToMaxOutputSize == null) continue;
                opBuilder.setAttr("pad_to_max_output_size", opts.padToMaxOutputSize);
            }
        }
        return new NonMaxSuppressionV5<T>(opBuilder.build());
    }

    public static Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
        return new Options().padToMaxOutputSize(padToMaxOutputSize);
    }

    public Output<Integer> selectedIndices() {
        return this.selectedIndices;
    }

    public Output<T> selectedScores() {
        return this.selectedScores;
    }

    public Output<Integer> validOutputs() {
        return this.validOutputs;
    }

    private NonMaxSuppressionV5(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.selectedIndices = operation.output(outputIdx++);
        this.selectedScores = operation.output(outputIdx++);
        this.validOutputs = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean padToMaxOutputSize;

        public Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
            this.padToMaxOutputSize = padToMaxOutputSize;
            return this;
        }

        private Options() {
        }
    }
}

