/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Skipgram
extends PrimitiveOp {
    private Output<String> vocabWord;
    private Output<Integer> vocabFreq;
    private Output<Long> wordsPerEpoch;
    private Output<Integer> currentEpoch;
    private Output<Long> totalWordsProcessed;
    private Output<Integer> examples;
    private Output<Integer> labels;

    public static Skipgram create(Scope scope, String filename, Long batchSize, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("Skipgram", scope.makeOpName("Skipgram"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("filename", filename);
        opBuilder.setAttr("batch_size", batchSize);
        if (options != null) {
            for (Options opts : options) {
                if (opts.windowSize != null) {
                    opBuilder.setAttr("window_size", opts.windowSize);
                }
                if (opts.minCount != null) {
                    opBuilder.setAttr("min_count", opts.minCount);
                }
                if (opts.subsample == null) continue;
                opBuilder.setAttr("subsample", opts.subsample.floatValue());
            }
        }
        return new Skipgram(opBuilder.build());
    }

    public static Options windowSize(Long windowSize) {
        return new Options().windowSize(windowSize);
    }

    public static Options minCount(Long minCount) {
        return new Options().minCount(minCount);
    }

    public static Options subsample(Float subsample) {
        return new Options().subsample(subsample);
    }

    public Output<String> vocabWord() {
        return this.vocabWord;
    }

    public Output<Integer> vocabFreq() {
        return this.vocabFreq;
    }

    public Output<Long> wordsPerEpoch() {
        return this.wordsPerEpoch;
    }

    public Output<Integer> currentEpoch() {
        return this.currentEpoch;
    }

    public Output<Long> totalWordsProcessed() {
        return this.totalWordsProcessed;
    }

    public Output<Integer> examples() {
        return this.examples;
    }

    public Output<Integer> labels() {
        return this.labels;
    }

    private Skipgram(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.vocabWord = operation.output(outputIdx++);
        this.vocabFreq = operation.output(outputIdx++);
        this.wordsPerEpoch = operation.output(outputIdx++);
        this.currentEpoch = operation.output(outputIdx++);
        this.totalWordsProcessed = operation.output(outputIdx++);
        this.examples = operation.output(outputIdx++);
        this.labels = operation.output(outputIdx++);
    }

    public static class Options {
        private Long windowSize;
        private Long minCount;
        private Float subsample;

        public Options windowSize(Long windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Options minCount(Long minCount) {
            this.minCount = minCount;
            return this;
        }

        public Options subsample(Float subsample) {
            this.subsample = subsample;
            return this;
        }

        private Options() {
        }
    }
}

