/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ThreadPoolHandle
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static ThreadPoolHandle create(Scope scope, Long numThreads, String displayName, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ThreadPoolHandle", scope.makeOpName("ThreadPoolHandle"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("num_threads", numThreads);
        opBuilder.setAttr("display_name", displayName);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxIntraOpParallelism != null) {
                    opBuilder.setAttr("max_intra_op_parallelism", opts.maxIntraOpParallelism);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new ThreadPoolHandle(opBuilder.build());
    }

    public static Options maxIntraOpParallelism(Long maxIntraOpParallelism) {
        return new Options().maxIntraOpParallelism(maxIntraOpParallelism);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private ThreadPoolHandle(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Long maxIntraOpParallelism;
        private String container;
        private String sharedName;

        public Options maxIntraOpParallelism(Long maxIntraOpParallelism) {
            this.maxIntraOpParallelism = maxIntraOpParallelism;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

