/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FusedBatchNormGrad<T extends Number, U extends Number>
extends PrimitiveOp {
    private Output<T> xBackprop;
    private Output<U> scaleBackprop;
    private Output<U> offsetBackprop;
    private Output<U> reserveSpace3;
    private Output<U> reserveSpace4;

    public static <T extends Number, U extends Number> FusedBatchNormGrad<T, U> create(Scope scope, Operand<T> yBackprop, Operand<T> x, Operand<Float> scale, Operand<U> reserveSpace1, Operand<U> reserveSpace2, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("FusedBatchNormGradV2", scope.makeOpName("FusedBatchNormGrad"));
        opBuilder.addInput(yBackprop.asOutput());
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(reserveSpace1.asOutput());
        opBuilder.addInput(reserveSpace2.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.epsilon != null) {
                    opBuilder.setAttr("epsilon", opts.epsilon.floatValue());
                }
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.isTraining == null) continue;
                opBuilder.setAttr("is_training", opts.isTraining);
            }
        }
        return new FusedBatchNormGrad<T, U>(opBuilder.build());
    }

    public static Options epsilon(Float epsilon) {
        return new Options().epsilon(epsilon);
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options isTraining(Boolean isTraining) {
        return new Options().isTraining(isTraining);
    }

    public Output<T> xBackprop() {
        return this.xBackprop;
    }

    public Output<U> scaleBackprop() {
        return this.scaleBackprop;
    }

    public Output<U> offsetBackprop() {
        return this.offsetBackprop;
    }

    public Output<U> reserveSpace3() {
        return this.reserveSpace3;
    }

    public Output<U> reserveSpace4() {
        return this.reserveSpace4;
    }

    private FusedBatchNormGrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.xBackprop = operation.output(outputIdx++);
        this.scaleBackprop = operation.output(outputIdx++);
        this.offsetBackprop = operation.output(outputIdx++);
        this.reserveSpace3 = operation.output(outputIdx++);
        this.reserveSpace4 = operation.output(outputIdx++);
    }

    public static class Options {
        private Float epsilon;
        private String dataFormat;
        private Boolean isTraining;

        public Options epsilon(Float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options isTraining(Boolean isTraining) {
            this.isTraining = isTraining;
            return this;
        }

        private Options() {
        }
    }
}

