/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class AddSparseToTensorsMap
extends PrimitiveOp
implements Operand<Long> {
    private Output<Long> sparseHandle;

    public static <T> AddSparseToTensorsMap create(Scope scope, Operand<Long> sparseIndices, Operand<T> sparseValues, Operand<Long> sparseShape, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("AddSparseToTensorsMap", scope.makeOpName("AddSparseToTensorsMap"));
        opBuilder.addInput(sparseIndices.asOutput());
        opBuilder.addInput(sparseValues.asOutput());
        opBuilder.addInput(sparseShape.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new AddSparseToTensorsMap(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<Long> sparseHandle() {
        return this.sparseHandle;
    }

    @Override
    public Output<Long> asOutput() {
        return this.sparseHandle;
    }

    private AddSparseToTensorsMap(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.sparseHandle = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

