/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse;

import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.ShortNdArray;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.ShortSparseSlice;
import org.tensorflow.ndarray.index.Index;

public class ShortSparseNdArray
extends AbstractSparseNdArray<Short, ShortNdArray>
implements ShortNdArray {
    protected ShortSparseNdArray(LongNdArray indices, ShortNdArray values, short defaultValue, DimensionalSpace dimensions) {
        super(indices, values, defaultValue, dimensions);
    }

    ShortSparseNdArray(LongNdArray indices, ShortNdArray values, DimensionalSpace dimensions) {
        this(indices, values, 0, dimensions);
    }

    ShortSparseNdArray(ShortDataBuffer dataBuffer, DimensionalSpace dimensions) {
        this(dataBuffer, 0, dimensions);
    }

    ShortSparseNdArray(ShortDataBuffer dataBuffer, short defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
        this.copyFrom(dataBuffer);
    }

    ShortSparseNdArray(DimensionalSpace dimensions) {
        this(0, dimensions);
    }

    ShortSparseNdArray(short defaultValue, DimensionalSpace dimensions) {
        super(defaultValue, dimensions);
    }

    public static ShortSparseNdArray create(LongNdArray indices, ShortNdArray values, DimensionalSpace dimensions) {
        return new ShortSparseNdArray(indices, values, dimensions);
    }

    public static ShortSparseNdArray create(LongNdArray indices, ShortNdArray values, short defaultValue, DimensionalSpace dimensions) {
        return new ShortSparseNdArray(indices, values, defaultValue, dimensions);
    }

    public static ShortSparseNdArray create(ShortDataBuffer dataBuffer, DimensionalSpace dimensions) {
        return new ShortSparseNdArray(dataBuffer, dimensions);
    }

    public static ShortSparseNdArray create(ShortDataBuffer dataBuffer, short defaultValue, DimensionalSpace dimensions) {
        return new ShortSparseNdArray(dataBuffer, defaultValue, dimensions);
    }

    public static ShortSparseNdArray create(DimensionalSpace dimensions) {
        return new ShortSparseNdArray(dimensions);
    }

    public static ShortSparseNdArray create(short defaultValue, DimensionalSpace dimensions) {
        return new ShortSparseNdArray(defaultValue, dimensions);
    }

    public static ShortSparseNdArray create(ShortDataBuffer buffer, Shape shape) {
        return new ShortSparseNdArray(buffer, DimensionalSpace.create(shape));
    }

    public static ShortSparseNdArray create(ShortDataBuffer buffer, short defaultValue, Shape shape) {
        return new ShortSparseNdArray(buffer, defaultValue, DimensionalSpace.create(shape));
    }

    public static ShortSparseNdArray create(ShortNdArray src) {
        ShortDataBuffer buffer = DataBuffers.ofShorts(src.size());
        src.copyTo(buffer);
        return new ShortSparseNdArray(buffer, DimensionalSpace.create(src.shape()));
    }

    public static ShortSparseNdArray create(ShortNdArray src, short defaultValue) {
        ShortDataBuffer buffer = DataBuffers.ofShorts(src.size());
        src.copyTo(buffer);
        return new ShortSparseNdArray(buffer, defaultValue, DimensionalSpace.create(src.shape()));
    }

    @Override
    public ShortNdArray createValues(Shape shape) {
        return NdArrays.ofShorts(shape);
    }

    @Override
    public ShortNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new ShortSparseSlice(this, position, sliceDimensions);
    }

    @Override
    public short getShort(long ... coordinates) {
        return (Short)this.getObject(coordinates);
    }

    @Override
    public ShortNdArray setShort(short value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortNdArray copyTo(DataBuffer<Short> dst) {
        return this.copyTo((ShortDataBuffer)dst);
    }

    @Override
    public ShortNdArray copyTo(ShortDataBuffer dst) {
        Object[] defaults = new Short[(int)this.shape().size()];
        Arrays.fill(defaults, this.getDefaultValue());
        dst.write(defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            short value = ((ShortNdArray)this.getValues()).getShort(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public ShortNdArray copyFrom(ShortDataBuffer src) {
        ArrayList<long[]> indices = new ArrayList<long[]>();
        ArrayList<Short> values = new ArrayList<Short>();
        int i = 0;
        while ((long)i < src.size()) {
            if (!src.getObject(i).equals(this.getDefaultValue())) {
                indices.add(this.toCoordinates(this.dimensions, i));
                values.add(src.getObject(i));
            }
            i = (short)(i + 1);
        }
        long[][] indicesArray = new long[indices.size()][];
        short[] valuesArray = new short[values.size()];
        for (int i2 = 0; i2 < indices.size(); ++i2) {
            indicesArray[i2] = (long[])indices.get(i2);
            valuesArray[i2] = (Short)values.get(i2);
        }
        this.setIndices(StdArrays.ndCopyOf(indicesArray));
        this.setValues(NdArrays.vectorOf(valuesArray));
        return this;
    }

    @Override
    public ShortNdArray copyFrom(DataBuffer<Short> src) {
        return this.copyFrom((ShortDataBuffer)src);
    }

    @Override
    public ShortNdArray toDense() {
        ShortDataBuffer dataBuffer = DataBuffers.ofShorts(this.shape().size());
        this.copyTo(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    public ShortNdArray fromDense(ShortNdArray src) {
        ShortDataBuffer buffer = DataBuffers.ofShorts(src.size());
        src.copyTo(buffer);
        this.copyFrom(buffer);
        return this;
    }

    @Override
    public ShortNdArray slice(Index ... indices) {
        return (ShortNdArray)super.slice(indices);
    }

    @Override
    public ShortNdArray get(long ... coordinates) {
        return (ShortNdArray)super.get(coordinates);
    }

    @Override
    public ShortNdArray setObject(Short value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortNdArray set(NdArray<Short> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ShortNdArray copyTo(NdArray<Short> dst) {
        return (ShortNdArray)super.copyTo(dst);
    }

    @Override
    public ShortNdArray createDefaultArray() {
        return NdArrays.scalarOf((Short)this.getDefaultValue());
    }
}

