/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.gpu;

import java.io.Closeable;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.Tensor;

public class GpuDelegate
implements Delegate,
Closeable {
    private static final long INVALID_DELEGATE_HANDLE = 0L;
    private static final String TFLITE_GPU_LIB = "tensorflowlite_gpu_jni";
    private long delegateHandle;

    public GpuDelegate(Options options) {
        this.delegateHandle = GpuDelegate.createDelegate(options.compileOptions.precisionLossAllowed, options.compileOptions.dynamicBatchEnabled, options.compileOptions.preferredGlObjectType);
    }

    public GpuDelegate() {
        this(new Options());
    }

    public boolean bindGlBufferToTensor(Tensor tensor, int ssbo) {
        return GpuDelegate.bindGlBufferToTensor(this.delegateHandle, tensor.index(), ssbo);
    }

    public long getNativeHandle() {
        return this.delegateHandle;
    }

    @Override
    public void close() {
        if (this.delegateHandle != 0L) {
            GpuDelegate.deleteDelegate(this.delegateHandle);
            this.delegateHandle = 0L;
        }
    }

    private static native long createDelegate(boolean var0, boolean var1, int var2);

    private static native void deleteDelegate(long var0);

    private static native boolean bindGlBufferToTensor(long var0, int var2, int var3);

    static {
        System.loadLibrary(TFLITE_GPU_LIB);
    }

    public static final class Options {
        private static final CompileOptions DEFAULT_COMPILE_OPTIONS = new CompileOptions();
        CompileOptions compileOptions = DEFAULT_COMPILE_OPTIONS;

        public Options setCompileOptions(CompileOptions compileOptions) {
            this.compileOptions = compileOptions != null ? compileOptions : DEFAULT_COMPILE_OPTIONS;
            return this;
        }
    }

    public static final class CompileOptions {
        public static final int GL_OBJECT_TYPE_FASTEST = 0;
        public static final int GL_OBJECT_TYPE_TEXTURE = 1;
        public static final int GL_OBJECT_TYPE_BUFFER = 2;
        boolean precisionLossAllowed = true;
        boolean dynamicBatchEnabled = false;
        int preferredGlObjectType = 0;

        public CompileOptions setPrecisionLossAllowed(boolean precisionLossAllowed) {
            this.precisionLossAllowed = precisionLossAllowed;
            return this;
        }

        public CompileOptions setDynamicBatchEnabled(boolean dynamicBatchEnabled) {
            this.dynamicBatchEnabled = dynamicBatchEnabled;
            return this;
        }

        public CompileOptions setPreferredGlObjectType(int preferredGlObjectType) {
            this.preferredGlObjectType = preferredGlObjectType;
            return this;
        }
    }
}

