/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.gpu;

import java.io.Closeable;
import org.tensorflow.lite.Delegate;

public class GpuDelegate
implements Delegate,
Closeable {
    private static final long INVALID_DELEGATE_HANDLE = 0L;
    private static final String TFLITE_GPU_LIB = "tensorflowlite_gpu_jni";
    private long delegateHandle;

    public GpuDelegate(Options options) {
        this.delegateHandle = GpuDelegate.createDelegate(options.precisionLossAllowed, options.inferencePreference);
    }

    public GpuDelegate() {
        this(new Options());
    }

    public long getNativeHandle() {
        return this.delegateHandle;
    }

    @Override
    public void close() {
        if (this.delegateHandle != 0L) {
            GpuDelegate.deleteDelegate(this.delegateHandle);
            this.delegateHandle = 0L;
        }
    }

    private static native long createDelegate(boolean var0, int var1);

    private static native void deleteDelegate(long var0);

    static {
        System.loadLibrary(TFLITE_GPU_LIB);
    }

    public static final class Options {
        public static final int INFERENCE_PREFERENCE_FAST_SINGLE_ANSWER = 0;
        public static final int INFERENCE_PREFERENCE_SUSTAINED_SPEED = 1;
        boolean precisionLossAllowed = true;
        int inferencePreference = 0;

        public Options setPrecisionLossAllowed(boolean precisionLossAllowed) {
            this.precisionLossAllowed = precisionLossAllowed;
            return this;
        }

        public Options setInferencePreference(int preference) {
            this.inferencePreference = preference;
            return this;
        }
    }
}

