/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.gpu;

import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.annotations.UsedByReflection;
import org.tensorflow.lite.gpu.GpuDelegateFactory;
import org.tensorflow.lite.gpu.GpuDelegateNative;

@UsedByReflection(value="TFLiteSupport/model/GpuDelegateProxy")
public class GpuDelegate
implements Delegate {
    private static final long INVALID_DELEGATE_HANDLE = 0L;
    private long delegateHandle;

    @UsedByReflection(value="GpuDelegateFactory")
    public GpuDelegate(GpuDelegateFactory.Options options) {
        GpuDelegateNative.init();
        this.delegateHandle = GpuDelegate.createDelegate(options.isPrecisionLossAllowed(), options.areQuantizedModelsAllowed(), options.getInferencePreference(), options.getSerializationDir(), options.getModelToken(), options.getForceBackend().value());
    }

    @UsedByReflection(value="TFLiteSupport/model/GpuDelegateProxy")
    public GpuDelegate() {
        this(new GpuDelegateFactory.Options());
    }

    public long getNativeHandle() {
        return this.delegateHandle;
    }

    public void close() {
        if (this.delegateHandle != 0L) {
            GpuDelegate.deleteDelegate(this.delegateHandle);
            this.delegateHandle = 0L;
        }
    }

    private static native long createDelegate(boolean var0, boolean var1, int var2, String var3, String var4, int var5);

    private static native void deleteDelegate(long var0);

    @Deprecated
    public static class Options
    extends GpuDelegateFactory.Options {
    }
}

