/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.core;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.util.Log;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class TaskJniUtils {
    public static final long INVALID_POINTER = 0L;
    private static final String TAG = TaskJniUtils.class.getSimpleName();

    public static <T> long createHandleFromFdAndOptions(Context context, final FdAndOptionsHandleProvider<T> provider, String libName, String filePath, final T options) throws IOException {
        try (final AssetFileDescriptor assetFileDescriptor = context.getAssets().openFd(filePath);){
            long l = TaskJniUtils.createHandleFromLibrary(new EmptyHandleProvider(){

                @Override
                public long createHandle() {
                    return provider.createHandle(assetFileDescriptor.getParcelFileDescriptor().getFd(), assetFileDescriptor.getLength(), assetFileDescriptor.getStartOffset(), options);
                }
            }, libName);
            return l;
        }
    }

    public static long createHandleFromLibrary(EmptyHandleProvider provider, String libName) {
        TaskJniUtils.tryLoadLibrary(libName);
        try {
            return provider.createHandle();
        }
        catch (RuntimeException e) {
            String errorMessage = "Error getting native address of native library: " + libName;
            Log.e((String)TAG, (String)errorMessage, (Throwable)e);
            throw new IllegalStateException(errorMessage, e);
        }
    }

    public static long createHandleWithMultipleAssetFilesFromLibrary(Context context, final MultipleBuffersHandleProvider provider, String libName, String ... filePaths) throws IOException {
        final MappedByteBuffer[] buffers = new MappedByteBuffer[filePaths.length];
        for (int i = 0; i < filePaths.length; ++i) {
            buffers[i] = TaskJniUtils.loadMappedFile(context, filePaths[i]);
        }
        return TaskJniUtils.createHandleFromLibrary(new EmptyHandleProvider(){

            @Override
            public long createHandle() {
                return provider.createHandle(buffers);
            }
        }, libName);
    }

    public static MappedByteBuffer loadMappedFile(Context context, String filePath) throws IOException {
        try (AssetFileDescriptor fileDescriptor = context.getAssets().openFd(filePath);){
            MappedByteBuffer mappedByteBuffer;
            try (FileInputStream inputStream = new FileInputStream(fileDescriptor.getFileDescriptor());){
                FileChannel fileChannel = inputStream.getChannel();
                long startOffset = fileDescriptor.getStartOffset();
                long declaredLength = fileDescriptor.getDeclaredLength();
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, startOffset, declaredLength);
            }
            return mappedByteBuffer;
        }
    }

    public static void tryLoadLibrary(String libName) {
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            String errorMessage = "Error loading native library: " + libName;
            Log.e((String)TAG, (String)errorMessage, (Throwable)e);
            throw new UnsatisfiedLinkError(errorMessage);
        }
    }

    private TaskJniUtils() {
    }

    public static interface FdAndOptionsHandleProvider<T> {
        public long createHandle(int var1, long var2, long var4, T var6);
    }

    public static interface MultipleBuffersHandleProvider {
        public long createHandle(ByteBuffer ... var1);
    }

    public static interface EmptyHandleProvider {
        public long createHandle();
    }
}

