/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.gms.vision.classifier;

import android.content.Context;
import android.graphics.Rect;
import android.os.ParcelFileDescriptor;
import com.google.android.odml.image.MlImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tensorflow.lite.support.image.MlImageAdapter;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.task.core.BaseOptions;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.annotations.UsedByReflection;
import org.tensorflow.lite.task.core.vision.ImageProcessingOptions;
import org.tensorflow.lite.task.gms.vision.classifier.Classifications;
import org.tensorflow.lite.task.gms.vision.classifier.zzb;
import org.tensorflow.lite.task.gms.vision.classifier.zzc;
import org.tensorflow.lite.task.gms.vision.classifier.zzd;
import org.tensorflow.lite.task.gms.vision.classifier.zze;
import org.tensorflow.lite.task.gms.vision.core.BaseVisionTaskApi;

public final class ImageClassifier
extends BaseVisionTaskApi {
    private static native long initJniWithByteBuffer(ByteBuffer var0, ImageClassifierOptions var1, long var2);

    private static native long initJniWithModelFdAndOptions(int var0, long var1, long var3, ImageClassifierOptions var5, long var6);

    /*
     * WARNING - void declaration
     */
    public List<Classifications> classify(MlImage image) {
        void var1_1;
        return this.classify((MlImage)var1_1, ImageProcessingOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public List<Classifications> classify(TensorImage image) {
        void var1_1;
        return this.classify((TensorImage)var1_1, ImageProcessingOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public List<Classifications> classify(MlImage image, ImageProcessingOptions options) {
        void var2_2;
        void var1_1;
        image.getInternal().acquire();
        TensorImage tensorImage = MlImageAdapter.createTensorImageFrom((MlImage)var1_1);
        Object object = object.classify(tensorImage, (ImageProcessingOptions)var2_2);
        var1_1.close();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public List<Classifications> classify(TensorImage image, ImageProcessingOptions options) {
        void var2_2;
        void var1_1;
        zze zze2 = new zze(this);
        return (List)this.run(zze2, (TensorImage)var1_1, (ImageProcessingOptions)var2_2);
    }

    private static native List<Classifications> classifyNative(long var0, long var2, int[] var4);

    public static ImageClassifier createFromBuffer(ByteBuffer modelBuffer) {
        return ImageClassifier.createFromBufferAndOptions(modelBuffer, ImageClassifierOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public static ImageClassifier createFromBufferAndOptions(ByteBuffer modelBuffer, ImageClassifierOptions options) {
        void var1_1;
        Object object;
        if (!modelBuffer.isDirect() && !(object instanceof MappedByteBuffer)) {
            object = new IllegalArgumentException("The model buffer should be either a direct ByteBuffer or a MappedByteBuffer.");
            throw object;
        }
        zzd zzd2 = new zzd((ByteBuffer)object, (ImageClassifierOptions)var1_1);
        ImageClassifier imageClassifier = new ImageClassifier(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)zzd2, (String)"task_vision_jni_gms"));
        return imageClassifier;
    }

    public static ImageClassifier createFromFile(File modelFile) throws IOException {
        return ImageClassifier.createFromFileAndOptions(modelFile, ImageClassifierOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public static ImageClassifier createFromFile(Context context, String modelPath) throws IOException {
        void var1_1;
        return ImageClassifier.createFromFileAndOptions(context, (String)var1_1, ImageClassifierOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageClassifier createFromFileAndOptions(File modelFile, ImageClassifierOptions options) throws IOException {
        ImageClassifier imageClassifier;
        File file = ParcelFileDescriptor.open((File)modelFile, (int)0x10000000);
        try {
            void var1_2;
            zzc zzc2 = new zzc((ParcelFileDescriptor)file, (ImageClassifierOptions)var1_2);
            imageClassifier = new ImageClassifier(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)zzc2, (String)"task_vision_jni_gms"));
            if (file == null) return imageClassifier;
        }
        catch (Throwable throwable) {
            if (file == null) throw throwable;
            try {
                file.close();
            }
            catch (Throwable throwable2) {
                try {
                    Object object = new Class[]{Throwable.class};
                    object = Throwable.class.getDeclaredMethod("addSuppressed", (Class<?>)object);
                    Object[] objectArray = new Object[]{throwable2};
                    ((Method)object).invoke((Object)throwable, objectArray);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            throw throwable;
        }
        file.close();
        return imageClassifier;
    }

    /*
     * WARNING - void declaration
     */
    public static ImageClassifier createFromFileAndOptions(Context context, String modelPath, ImageClassifierOptions options) throws IOException {
        void var2_2;
        void var1_1;
        Context context2;
        zzb zzb2 = new zzb();
        ImageClassifier imageClassifier = new ImageClassifier(TaskJniUtils.createHandleFromFdAndOptions((Context)context2, (TaskJniUtils.FdAndOptionsHandleProvider)zzb2, (String)"task_vision_jni_gms", (String)var1_1, (Object)var2_2));
        return imageClassifier;
    }

    ImageClassifier(long l) {
        super(l);
    }

    /*
     * WARNING - void declaration
     */
    protected void deinit(long nativeHandle) {
        void var1_1;
        this.deinitJni((long)var1_1);
    }

    private native void deinitJni(long var1);

    static /* bridge */ /* synthetic */ long zza(ByteBuffer byteBuffer, ImageClassifierOptions imageClassifierOptions, long l) {
        return ImageClassifier.initJniWithByteBuffer(byteBuffer, imageClassifierOptions, l);
    }

    static /* bridge */ /* synthetic */ long zzb(int n, long l, long l2, ImageClassifierOptions imageClassifierOptions, long l3) {
        return ImageClassifier.initJniWithModelFdAndOptions(n, l, l2, imageClassifierOptions, l3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ List zzc(ImageClassifier object, long l, int n, int n2, ImageProcessingOptions imageProcessingOptions) {
        void var1_2;
        void var4_5;
        void var3_3;
        Rect rect;
        object.checkNotClosed();
        Rect rect2 = rect.getRoi().isEmpty() ? (rect = new Rect(0, 0, (int)var3_3, (int)var4_5)) : rect.getRoi();
        long l2 = object.getNativeHandle();
        int[] nArray = new int[]{rect2.left, rect2.top, rect2.width(), rect2.height()};
        return ImageClassifier.classifyNative(l2, (long)var1_2, nArray);
    }

    @UsedByReflection(value="image_classifier_jni.cc")
    public static class ImageClassifierOptions {
        private final BaseOptions zza;
        private final String zzb;
        private final int zzc;
        private final float zzd;
        private final boolean zze;
        private final List zzf;
        private final List zzg;
        private final int zzh;

        @UsedByReflection(value="image_classifier_jni.cc")
        public float getScoreThreshold() {
            return this.zzd;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public int getMaxResults() {
            return this.zzc;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public int getNumThreads() {
            return this.zzh;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public String getDisplayNamesLocale() {
            return this.zzb;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public List<String> getLabelAllowList() {
            ArrayList<String> arrayList = new ArrayList<String>(this.zzf);
            return arrayList;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public List<String> getLabelDenyList() {
            ArrayList<String> arrayList = new ArrayList<String>(this.zzg);
            return arrayList;
        }

        public BaseOptions getBaseOptions() {
            return this.zza;
        }

        public static Builder builder() {
            Builder builder = new Builder();
            return builder;
        }

        ImageClassifierOptions(Builder builder) {
            this.zzb = builder.zzb;
            this.zzc = builder.zzc;
            this.zzd = builder.zzd;
            this.zze = builder.zze;
            this.zzf = builder.zzf;
            this.zzg = builder.zzg;
            this.zzh = builder.zzh;
            this.zza = builder.zza;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public boolean getIsScoreThresholdSet() {
            return this.zze;
        }

        public static class Builder {
            private BaseOptions zza = BaseOptions.builder().build();
            private String zzb = "en";
            private int zzc = -1;
            private float zzd;
            private boolean zze = false;
            private List zzf;
            private List zzg;
            private int zzh;

            /*
             * WARNING - void declaration
             */
            public Builder setBaseOptions(BaseOptions baseOptions) {
                void var1_1;
                this.zza = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setDisplayNamesLocale(String displayNamesLocale) {
                void var1_1;
                this.zzb = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setLabelAllowList(List<String> labelAllowList) {
                void var1_1;
                ArrayList arrayList = new ArrayList(var1_1);
                this.zzf = Collections.unmodifiableList(arrayList);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setLabelDenyList(List<String> labelDenyList) {
                void var1_1;
                ArrayList arrayList = new ArrayList(var1_1);
                this.zzg = Collections.unmodifiableList(arrayList);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setMaxResults(int maxResults) {
                void var1_1;
                if (maxResults == 0) {
                    Object object = new IllegalArgumentException("maxResults cannot be 0.");
                    throw object;
                }
                ((Builder)object).zzc = var1_1;
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @Deprecated
            public Builder setNumThreads(int numThreads) {
                void var1_1;
                this.zzh = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setScoreThreshold(float scoreThreshold) {
                void var1_1;
                this.zzd = var1_1;
                this.zze = true;
                return this;
            }

            public ImageClassifierOptions build() {
                ImageClassifierOptions imageClassifierOptions = new ImageClassifierOptions(this);
                return imageClassifierOptions;
            }

            Builder() {
                ArrayList arrayList;
                this.zzf = arrayList = new ArrayList();
                this.zzg = arrayList = new ArrayList();
                this.zzh = -1;
            }
        }
    }
}

