/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.gms.vision.core;

import android.media.Image;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.common.internal.SupportPreconditions;
import org.tensorflow.lite.support.image.ColorSpaceType;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.vision.ImageProcessingOptions;
import org.tensorflow.lite.task.gms.vision.core.zza;
import org.tensorflow.lite.task.gms.vision.core.zzb;

public abstract class BaseVisionTaskApi
extends BaseTaskApi {
    private static native long createFrameBufferFromByteBuffer(ByteBuffer var0, int var1, int var2, int var3, int var4);

    private static native long createFrameBufferFromBytes(byte[] var0, int var1, int var2, int var3, int var4, long[] var5);

    private static native long createFrameBufferFromPlanes(ByteBuffer var0, ByteBuffer var1, ByteBuffer var2, int var3, int var4, int var5, int var6, int var7, int var8);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected <T> T run(InferenceProvider<T> provider, TensorImage image, ImageProcessingOptions options) {
        void var3_29;
        void var1_24;
        void var0_7;
        long l;
        StringBuilder stringBuilder;
        block13: {
            void var0_16;
            void var0_14;
            void var0_12;
            Image image2;
            Object object;
            int n;
            block14: {
                n = options.getOrientation().getValue();
                ColorSpaceType colorSpaceType = stringBuilder.getColorSpaceType();
                switch (zzb.zza[colorSpaceType.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        void var0_3;
                        if (stringBuilder.getDataType() == DataType.UINT8) {
                            void var0_2 = stringBuilder;
                        } else {
                            TensorImage tensorImage = TensorImage.createFrom((TensorImage)stringBuilder, (DataType)DataType.UINT8);
                        }
                        object = var0_3.getBuffer();
                        ((ByteBuffer)object).rewind();
                        ColorSpaceType colorSpaceType2 = stringBuilder.getColorSpaceType();
                        if (((ByteBuffer)object).isDirect()) {
                            int n2 = var0_3.getWidth();
                            int n3 = var0_3.getHeight();
                            int n4 = colorSpaceType2.getValue();
                            l = BaseVisionTaskApi.createFrameBufferFromByteBuffer((ByteBuffer)object, n2, n3, n, n4);
                            byte[] byArray = new byte[]{};
                            Object object2 = object = new zza(l, 0L, byArray);
                            break block13;
                        } else {
                            long[] lArray = new long[1];
                            if (((ByteBuffer)object).hasArray() && ((ByteBuffer)object).arrayOffset() == 0) {
                                object = ((ByteBuffer)object).array();
                            } else {
                                ((ByteBuffer)object).rewind();
                                byte[] byArray = new byte[((Buffer)object).limit()];
                                ((ByteBuffer)object).get(byArray, 0, byArray.length);
                                object = byArray;
                            }
                            int n5 = var0_3.getWidth();
                            int n6 = var0_3.getHeight();
                            int n7 = colorSpaceType2.getValue();
                            l = BaseVisionTaskApi.createFrameBufferFromBytes((byte[])object, n5, n6, n, n7, lArray);
                            long l2 = lArray[0];
                            zza zza2 = new zza(l, l2, (byte[])object);
                        }
                        break block13;
                    }
                    case 6: {
                        image2 = stringBuilder.getMediaImage();
                        if (image2.getFormat() != 35) break;
                        boolean bl = true;
                        break block14;
                    }
                    default: {
                        String string = colorSpaceType.name();
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("Color space type, ");
                        stringBuilder.append(string);
                        stringBuilder.append(", is unsupported.");
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.toString());
                        throw illegalArgumentException;
                    }
                }
                boolean bl = false;
            }
            SupportPreconditions.checkArgument((boolean)var0_12, (Object)"Only supports loading YUV_420_888 Image.");
            Image.Plane plane = image2.getPlanes();
            int n8 = ((Image.Plane[])plane).length;
            if (n8 == 3) {
                boolean bl = true;
            } else {
                boolean bl = false;
            }
            Object object3 = new Object[]{n8};
            SupportPreconditions.checkArgument((boolean)var0_14, (Object)String.format("The input image should have 3 planes, but got %d plane(s).", (Object[])object3));
            boolean bl = false;
            while (var0_16 < n8) {
                object3 = plane[var0_16].getBuffer();
                SupportPreconditions.checkNotNull((Object)object3, (Object)"The image buffer is corrupted and the plane is null.");
                SupportPreconditions.checkArgument((boolean)((ByteBuffer)object3).isDirect(), (Object)"The image plane buffer is not a direct ByteBuffer, and is not supported.");
                ((ByteBuffer)object3).rewind();
                ++var0_16;
            }
            Image.Plane plane2 = plane[0];
            ByteBuffer byteBuffer = plane2.getBuffer();
            Image.Plane plane3 = plane[1];
            ByteBuffer byteBuffer2 = plane3.getBuffer();
            object3 = plane[2];
            object3 = object3.getBuffer();
            int n9 = image2.getWidth();
            int n10 = image2.getHeight();
            Image.Plane plane4 = plane[0];
            int n11 = plane4.getRowStride();
            Image.Plane plane5 = plane[1];
            int n12 = plane5.getRowStride();
            plane = plane[1];
            int n13 = plane.getPixelStride();
            l = BaseVisionTaskApi.createFrameBufferFromPlanes(byteBuffer, byteBuffer2, (ByteBuffer)object3, n9, n10, n11, n12, n13, n);
            byte[] byArray = new byte[]{};
            Object object4 = object = new zza(l, 0L, byArray);
        }
        l = var0_7.zzb();
        int n = stringBuilder.getWidth();
        int n14 = stringBuilder.getHeight();
        Object t = var1_24.run(l, n, n14, (ImageProcessingOptions)var3_29);
        BaseVisionTaskApi.deleteFrameBuffer(var0_7.zzb(), var0_7.zza(), var0_7.zzc());
        return t;
    }

    /*
     * WARNING - void declaration
     */
    protected BaseVisionTaskApi(long nativeHandle) {
        super((long)var1_1);
        void var1_1;
    }

    private static native void deleteFrameBuffer(long var0, long var2, byte[] var4);

    public static interface InferenceProvider<T> {
        public T run(long var1, int var3, int var4, ImageProcessingOptions var5);
    }
}

