/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.gms.vision.segmenter;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import com.google.android.odml.image.MlImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.tensorflow.lite.support.image.MlImageAdapter;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.task.core.BaseOptions;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.vision.ImageProcessingOptions;
import org.tensorflow.lite.task.gms.vision.core.BaseVisionTaskApi;
import org.tensorflow.lite.task.gms.vision.segmenter.ColoredLabel;
import org.tensorflow.lite.task.gms.vision.segmenter.OutputType;
import org.tensorflow.lite.task.gms.vision.segmenter.Segmentation;
import org.tensorflow.lite.task.gms.vision.segmenter.zzb;
import org.tensorflow.lite.task.gms.vision.segmenter.zze;
import org.tensorflow.lite.task.gms.vision.segmenter.zzf;
import org.tensorflow.lite.task.gms.vision.segmenter.zzg;
import org.tensorflow.lite.task.gms.vision.segmenter.zzh;
import org.tensorflow.lite.task.gms.vision.segmenter.zzi;

public final class ImageSegmenter
extends BaseVisionTaskApi {
    private final OutputType zza;

    private static native long initJniWithByteBuffer(ByteBuffer var0, String var1, int var2, long var3);

    private static native long initJniWithModelFdAndOptions(int var0, long var1, long var3, String var5, int var6, long var7);

    /*
     * WARNING - void declaration
     */
    public List<Segmentation> segment(MlImage image) {
        void var1_1;
        return this.segment((MlImage)var1_1, ImageProcessingOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public List<Segmentation> segment(TensorImage image) {
        void var1_1;
        return this.segment((TensorImage)var1_1, ImageProcessingOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public List<Segmentation> segment(long frameBufferHandle, ImageProcessingOptions imageProcessingOptions) {
        void var1_1;
        this_.checkNotClosed();
        List<Object> list = new List<Object>();
        ArrayList<ColoredLabel> arrayList = new ArrayList<ColoredLabel>();
        Object object = new int[2];
        ImageSegmenter.segmentNative(this_.getNativeHandle(), (long)var1_1, list, object, arrayList);
        ArrayList<ColoredLabel> arrayList2 = new ArrayList<ColoredLabel>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])list.get(i));
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            arrayList2.add((ColoredLabel)((Object)byteBuffer));
        }
        Segmentation[] segmentationArray = new Segmentation[1];
        OutputType this_ = ((ImageSegmenter)((Object)this_)).zza;
        list = this_.zza(arrayList2, (int[])object);
        this_.zzb(list, arrayList);
        object = new zze;
        arrayList2 = new ArrayList<ColoredLabel>(list);
        list = Collections.unmodifiableList(arrayList2);
        arrayList2 = new ArrayList<ColoredLabel>(arrayList);
        object(this_, list, Collections.unmodifiableList(arrayList2));
        segmentationArray[0] = object;
        return Arrays.asList(segmentationArray);
    }

    /*
     * WARNING - void declaration
     */
    public List<Segmentation> segment(MlImage image, ImageProcessingOptions options) {
        void var2_2;
        void var1_1;
        image.getInternal().acquire();
        TensorImage tensorImage = MlImageAdapter.createTensorImageFrom((MlImage)var1_1);
        Object object = object.segment(tensorImage, (ImageProcessingOptions)var2_2);
        var1_1.close();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public List<Segmentation> segment(TensorImage image, ImageProcessingOptions options) {
        void var2_2;
        void var1_1;
        zzh zzh2 = new zzh(this);
        return (List)this.run(zzh2, (TensorImage)var1_1, (ImageProcessingOptions)var2_2);
    }

    public static ImageSegmenter createFromBuffer(ByteBuffer modelBuffer) {
        return ImageSegmenter.createFromBufferAndOptions(modelBuffer, ImageSegmenterOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public static ImageSegmenter createFromBufferAndOptions(ByteBuffer modelBuffer, ImageSegmenterOptions options) {
        void var1_1;
        Object object;
        if (!modelBuffer.isDirect() && !(object instanceof MappedByteBuffer)) {
            object = new IllegalArgumentException("The model buffer should be either a direct ByteBuffer or a MappedByteBuffer.");
            throw object;
        }
        zzg zzg2 = new zzg((ByteBuffer)object, (ImageSegmenterOptions)var1_1);
        ImageSegmenter imageSegmenter = new ImageSegmenter(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)zzg2, (String)"task_vision_jni_gms"), var1_1.getOutputType());
        return imageSegmenter;
    }

    public static ImageSegmenter createFromFile(File modelFile) throws IOException {
        return ImageSegmenter.createFromFileAndOptions(modelFile, ImageSegmenterOptions.builder().build());
    }

    /*
     * WARNING - void declaration
     */
    public static ImageSegmenter createFromFile(Context context, String modelPath) throws IOException {
        void var1_1;
        return ImageSegmenter.createFromFileAndOptions(context, (String)var1_1, ImageSegmenterOptions.builder().build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageSegmenter createFromFileAndOptions(File modelFile, ImageSegmenterOptions options) throws IOException {
        ImageSegmenter imageSegmenter;
        File file = ParcelFileDescriptor.open((File)modelFile, (int)0x10000000);
        try {
            imageSegmenter = ImageSegmenter.zzc(file.getFd(), -1L, -1L, (ImageSegmenterOptions)((Object)imageSegmenter));
            if (file == null) return imageSegmenter;
        }
        catch (Throwable throwable) {
            if (file == null) throw throwable;
            try {
                file.close();
            }
            catch (Throwable throwable2) {
                zzf.zza(throwable, throwable2);
                throw throwable;
            }
            throw throwable;
        }
        file.close();
        return imageSegmenter;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageSegmenter createFromFileAndOptions(Context context, String modelPath, ImageSegmenterOptions options) throws IOException {
        ImageSegmenter imageSegmenter;
        Context context2 = context.getAssets().openFd((String)((Object)imageSegmenter));
        try {
            void var2_4;
            imageSegmenter = ImageSegmenter.zzc(context2.getParcelFileDescriptor().getFd(), context2.getLength(), context2.getStartOffset(), (ImageSegmenterOptions)var2_4);
            if (context2 == null) return imageSegmenter;
        }
        catch (Throwable throwable) {
            if (context2 == null) throw throwable;
            try {
                context2.close();
            }
            catch (Throwable throwable2) {
                zzf.zza(throwable, throwable2);
                throw throwable;
            }
            throw throwable;
        }
        context2.close();
        return imageSegmenter;
    }

    private ImageSegmenter(long l, OutputType outputType) {
        super(l);
        this.zza = outputType;
    }

    /*
     * WARNING - void declaration
     */
    protected void deinit(long nativeHandle) {
        void var1_1;
        this.deinitJni((long)var1_1);
    }

    private native void deinitJni(long var1);

    private static native void segmentNative(long var0, long var2, List<byte[]> var4, int[] var5, List<ColoredLabel> var6);

    static /* bridge */ /* synthetic */ long zza(ByteBuffer byteBuffer, String string, int n, long l) {
        return ImageSegmenter.initJniWithByteBuffer(byteBuffer, string, n, l);
    }

    static /* bridge */ /* synthetic */ long zzb(int n, long l, long l2, String string, int n2, long l3) {
        return ImageSegmenter.initJniWithModelFdAndOptions(n, l, l2, string, n2, l3);
    }

    private static ImageSegmenter zzc(int n, long l, long l2, ImageSegmenterOptions imageSegmenterOptions) {
        zzi zzi2 = new zzi(n, l, l2, imageSegmenterOptions);
        l = TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)zzi2, (String)"task_vision_jni_gms");
        ImageSegmenter imageSegmenter = new ImageSegmenter(l, imageSegmenterOptions.getOutputType());
        return imageSegmenter;
    }

    public static abstract class ImageSegmenterOptions {
        private static final OutputType zza = OutputType.CATEGORY_MASK;

        public abstract int getNumThreads();

        public abstract String getDisplayNamesLocale();

        public abstract BaseOptions getBaseOptions();

        public static Builder builder() {
            zzb zzb2 = new zzb();
            zzb2.setDisplayNamesLocale("en");
            ((Builder)zzb2).setOutputType(zza);
            ((Builder)zzb2).setNumThreads(-1);
            ((Builder)zzb2).setBaseOptions(BaseOptions.builder().build());
            return zzb2;
        }

        public abstract OutputType getOutputType();

        public static abstract class Builder {
            public abstract Builder setBaseOptions(BaseOptions var1);

            public abstract Builder setDisplayNamesLocale(String var1);

            @Deprecated
            public abstract Builder setNumThreads(int var1);

            public abstract Builder setOutputType(OutputType var1);

            public abstract ImageSegmenterOptions build();
        }
    }
}

