/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.NativeInterpreterWrapper;
import org.tensorflow.lite.Tensor;

public final class Interpreter
implements AutoCloseable {
    NativeInterpreterWrapper wrapper;

    public Interpreter(@NonNull File modelFile) {
        this(modelFile, null);
    }

    @Deprecated
    public Interpreter(@NonNull File modelFile, int numThreads) {
        this(modelFile, new Options().setNumThreads(numThreads));
    }

    public Interpreter(@NonNull File modelFile, Options options) {
        this.wrapper = new NativeInterpreterWrapper(modelFile.getAbsolutePath(), options);
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer) {
        this(byteBuffer, null);
    }

    @Deprecated
    public Interpreter(@NonNull ByteBuffer byteBuffer, int numThreads) {
        this(byteBuffer, new Options().setNumThreads(numThreads));
    }

    @Deprecated
    public Interpreter(@NonNull MappedByteBuffer mappedByteBuffer) {
        this((ByteBuffer)mappedByteBuffer, null);
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer, Options options) {
        this.wrapper = new NativeInterpreterWrapper(byteBuffer, options);
    }

    public void run(@NonNull Object input, @NonNull Object output) {
        Object[] inputs = new Object[]{input};
        HashMap<Integer, Object> outputs = new HashMap<Integer, Object>();
        outputs.put(0, output);
        this.runForMultipleInputsOutputs(inputs, outputs);
    }

    public void runForMultipleInputsOutputs(@NonNull Object[] inputs, @NonNull Map<Integer, Object> outputs) {
        this.checkNotClosed();
        this.wrapper.run(inputs, outputs);
    }

    public void resizeInput(int idx, @NonNull int[] dims) {
        this.checkNotClosed();
        this.wrapper.resizeInput(idx, dims);
    }

    public int getInputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getInputTensorCount();
    }

    public int getInputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getInputIndex(opName);
    }

    public Tensor getInputTensor(int inputIndex) {
        this.checkNotClosed();
        return this.wrapper.getInputTensor(inputIndex);
    }

    public int getOutputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getOutputTensorCount();
    }

    public int getOutputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getOutputIndex(opName);
    }

    public Tensor getOutputTensor(int outputIndex) {
        this.checkNotClosed();
        return this.wrapper.getOutputTensor(outputIndex);
    }

    public Long getLastNativeInferenceDurationNanoseconds() {
        this.checkNotClosed();
        return this.wrapper.getLastNativeInferenceDurationNanoseconds();
    }

    @Deprecated
    public void setUseNNAPI(boolean useNNAPI) {
        this.checkNotClosed();
        this.wrapper.setUseNNAPI(useNNAPI);
    }

    @Deprecated
    public void setNumThreads(int numThreads) {
        this.checkNotClosed();
        this.wrapper.setNumThreads(numThreads);
    }

    @Override
    public void close() {
        if (this.wrapper != null) {
            this.wrapper.close();
            this.wrapper = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void checkNotClosed() {
        if (this.wrapper == null) {
            throw new IllegalStateException("Internal error: The Interpreter has already been closed.");
        }
    }

    public static class Options {
        int numThreads = -1;
        boolean useNNAPI = false;
        boolean allowFp16PrecisionForFp32 = false;

        public Options setNumThreads(int numThreads) {
            this.numThreads = numThreads;
            return this;
        }

        public Options setUseNNAPI(boolean useNNAPI) {
            this.useNNAPI = useNNAPI;
            return this;
        }

        public Options setAllowFp16PrecisionForFp32(boolean allow) {
            this.allowFp16PrecisionForFp32 = allow;
            return this;
        }
    }
}

