/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.DelegateFactory;
import org.tensorflow.lite.InterpreterApi;
import org.tensorflow.lite.InterpreterImpl;
import org.tensorflow.lite.NativeInterpreterWrapperExperimental;
import org.tensorflow.lite.Tensor;

public final class Interpreter
extends InterpreterImpl
implements InterpreterApi {
    NativeInterpreterWrapperExperimental wrapperExperimental;
    String[] signatureKeyList;

    public Interpreter(@NonNull File modelFile) {
        this(modelFile, null);
    }

    public Interpreter(@NonNull File modelFile, Options options) {
        this(new NativeInterpreterWrapperExperimental(modelFile.getAbsolutePath(), (InterpreterImpl.Options)options));
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer) {
        this(byteBuffer, null);
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer, Options options) {
        this(new NativeInterpreterWrapperExperimental(byteBuffer, (InterpreterImpl.Options)options));
    }

    private Interpreter(NativeInterpreterWrapperExperimental wrapper) {
        super(wrapper);
        this.wrapperExperimental = wrapper;
        this.signatureKeyList = this.getSignatureKeys();
    }

    public void runSignature(@NonNull Map<String, Object> inputs, @NonNull Map<String, Object> outputs, String signatureKey) {
        this.checkNotClosed();
        if (signatureKey == null && this.signatureKeyList.length == 1) {
            signatureKey = this.signatureKeyList[0];
        }
        if (signatureKey == null) {
            throw new IllegalArgumentException("Input error: SignatureDef signatureKey should not be null. null is only allowed if the model has a single Signature. Available Signatures: " + Arrays.toString(this.signatureKeyList));
        }
        this.wrapper.runSignature(inputs, outputs, signatureKey);
    }

    public void runSignature(@NonNull Map<String, Object> inputs, @NonNull Map<String, Object> outputs) {
        this.checkNotClosed();
        this.runSignature(inputs, outputs, null);
    }

    public Tensor getInputTensorFromSignature(String inputName, String signatureKey) {
        this.checkNotClosed();
        if (signatureKey == null && this.signatureKeyList.length == 1) {
            signatureKey = this.signatureKeyList[0];
        }
        if (signatureKey == null) {
            throw new IllegalArgumentException("Input error: SignatureDef signatureKey should not be null. null is only allowed if the model has a single Signature. Available Signatures: " + Arrays.toString(this.signatureKeyList));
        }
        return this.wrapper.getInputTensor(inputName, signatureKey);
    }

    public String[] getSignatureKeys() {
        this.checkNotClosed();
        return this.wrapper.getSignatureKeys();
    }

    public String[] getSignatureInputs(String signatureKey) {
        this.checkNotClosed();
        return this.wrapper.getSignatureInputs(signatureKey);
    }

    public String[] getSignatureOutputs(String signatureKey) {
        this.checkNotClosed();
        return this.wrapper.getSignatureOutputs(signatureKey);
    }

    public Tensor getOutputTensorFromSignature(String outputName, String signatureKey) {
        this.checkNotClosed();
        if (signatureKey == null && this.signatureKeyList.length == 1) {
            signatureKey = this.signatureKeyList[0];
        }
        if (signatureKey == null) {
            throw new IllegalArgumentException("Input error: SignatureDef signatureKey should not be null. null is only allowed if the model has a single Signature. Available Signatures: " + Arrays.toString(this.signatureKeyList));
        }
        return this.wrapper.getOutputTensor(outputName, signatureKey);
    }

    public void resetVariableTensors() {
        this.checkNotClosed();
        this.wrapperExperimental.resetVariableTensors();
    }

    public void setCancelled(boolean cancelled) {
        this.wrapper.setCancelled(cancelled);
    }

    public static class Options
    extends InterpreterImpl.Options {
        public Options() {
        }

        public Options(InterpreterApi.Options options) {
            super(options);
        }

        Options(InterpreterImpl.Options options) {
            super(options);
        }

        public Options setNumThreads(int numThreads) {
            super.setNumThreads(numThreads);
            return this;
        }

        public Options setUseNNAPI(boolean useNNAPI) {
            super.setUseNNAPI(useNNAPI);
            return this;
        }

        @Deprecated
        public Options setAllowFp16PrecisionForFp32(boolean allow) {
            this.allowFp16PrecisionForFp32 = allow;
            return this;
        }

        public Options addDelegate(Delegate delegate) {
            super.addDelegate(delegate);
            return this;
        }

        public Options addDelegateFactory(DelegateFactory delegateFactory) {
            super.addDelegateFactory(delegateFactory);
            return this;
        }

        public Options setAllowBufferHandleOutput(boolean allow) {
            this.allowBufferHandleOutput = allow;
            return this;
        }

        public Options setCancellable(boolean allow) {
            super.setCancellable(allow);
            return this;
        }

        public Options setUseXNNPACK(boolean useXNNPACK) {
            this.useXNNPACK = useXNNPACK;
            return this;
        }

        public Options setRuntime(InterpreterApi.Options.TfLiteRuntime runtime) {
            super.setRuntime(runtime);
            return this;
        }
    }
}

