/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.InterpreterApi;
import org.tensorflow.lite.NativeInterpreterWrapper;
import org.tensorflow.lite.Tensor;

class InterpreterImpl
implements InterpreterApi {
    NativeInterpreterWrapper wrapper;

    public InterpreterImpl(@NonNull File modelFile) {
        this(modelFile, null);
    }

    public InterpreterImpl(@NonNull File modelFile, Options options) {
        this.wrapper = new NativeInterpreterWrapper(modelFile.getAbsolutePath(), options);
    }

    public InterpreterImpl(@NonNull ByteBuffer byteBuffer) {
        this(byteBuffer, null);
    }

    public InterpreterImpl(@NonNull ByteBuffer byteBuffer, Options options) {
        this.wrapper = new NativeInterpreterWrapper(byteBuffer, options);
    }

    InterpreterImpl(NativeInterpreterWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void run(Object input, Object output) {
        Object[] inputs = new Object[]{input};
        HashMap<Integer, Object> outputs = new HashMap<Integer, Object>();
        outputs.put(0, output);
        this.runForMultipleInputsOutputs(inputs, outputs);
    }

    public void runForMultipleInputsOutputs(Object @NonNull [] inputs, @NonNull Map<Integer, Object> outputs) {
        this.checkNotClosed();
        this.wrapper.run(inputs, outputs);
    }

    public void allocateTensors() {
        this.checkNotClosed();
        this.wrapper.allocateTensors();
    }

    public void resizeInput(int idx, @NonNull int[] dims) {
        this.checkNotClosed();
        this.wrapper.resizeInput(idx, dims, false);
    }

    public void resizeInput(int idx, @NonNull int[] dims, boolean strict) {
        this.checkNotClosed();
        this.wrapper.resizeInput(idx, dims, strict);
    }

    public int getInputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getInputTensorCount();
    }

    public int getInputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getInputIndex(opName);
    }

    public Tensor getInputTensor(int inputIndex) {
        this.checkNotClosed();
        return this.wrapper.getInputTensor(inputIndex);
    }

    public int getOutputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getOutputTensorCount();
    }

    public int getOutputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getOutputIndex(opName);
    }

    public Tensor getOutputTensor(int outputIndex) {
        this.checkNotClosed();
        return this.wrapper.getOutputTensor(outputIndex);
    }

    public Long getLastNativeInferenceDurationNanoseconds() {
        this.checkNotClosed();
        return this.wrapper.getLastNativeInferenceDurationNanoseconds();
    }

    int getExecutionPlanLength() {
        this.checkNotClosed();
        return this.wrapper.getExecutionPlanLength();
    }

    public void close() {
        if (this.wrapper != null) {
            this.wrapper.close();
            this.wrapper = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    void checkNotClosed() {
        if (this.wrapper == null) {
            throw new IllegalStateException("Internal error: The Interpreter has already been closed.");
        }
    }

    static class Options
    extends InterpreterApi.Options {
        Boolean allowFp16PrecisionForFp32;
        Boolean allowBufferHandleOutput;
        Boolean useXNNPACK;

        public Options() {
        }

        public Options(InterpreterApi.Options options) {
            super(options);
        }

        public Options(Options other) {
            super((InterpreterApi.Options)other);
            this.allowFp16PrecisionForFp32 = other.allowFp16PrecisionForFp32;
            this.allowBufferHandleOutput = other.allowBufferHandleOutput;
            this.useXNNPACK = other.useXNNPACK;
        }
    }
}

