/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.NativeInterpreterWrapper;
import org.tensorflow.lite.Tensor;

public final class Interpreter
implements AutoCloseable {
    NativeInterpreterWrapper wrapper;
    String[] signatureNameList;

    public Interpreter(@NonNull File modelFile) {
        this(modelFile, null);
    }

    @Deprecated
    public Interpreter(@NonNull File modelFile, int numThreads) {
        this(modelFile, new Options().setNumThreads(numThreads));
    }

    public Interpreter(@NonNull File modelFile, Options options) {
        this.wrapper = new NativeInterpreterWrapper(modelFile.getAbsolutePath(), options);
        this.signatureNameList = this.getSignatureDefNames();
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer) {
        this(byteBuffer, null);
    }

    @Deprecated
    public Interpreter(@NonNull ByteBuffer byteBuffer, int numThreads) {
        this(byteBuffer, new Options().setNumThreads(numThreads));
    }

    @Deprecated
    public Interpreter(@NonNull MappedByteBuffer mappedByteBuffer) {
        this((ByteBuffer)mappedByteBuffer, null);
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer, Options options) {
        this.wrapper = new NativeInterpreterWrapper(byteBuffer, options);
        this.signatureNameList = this.getSignatureDefNames();
    }

    public void run(Object input, Object output) {
        Object[] inputs = new Object[]{input};
        HashMap<Integer, Object> outputs = new HashMap<Integer, Object>();
        outputs.put(0, output);
        this.runForMultipleInputsOutputs(inputs, outputs);
    }

    public void runForMultipleInputsOutputs(@NonNull Object[] inputs, @NonNull Map<Integer, Object> outputs) {
        this.checkNotClosed();
        this.wrapper.run(inputs, outputs);
    }

    public void runSignature(@NonNull Map<String, Object> inputs, @NonNull Map<String, Object> outputs, String methodName) {
        this.checkNotClosed();
        if (methodName == null && this.signatureNameList.length == 1) {
            methodName = this.signatureNameList[0];
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Input error: SignatureDef methodName should not be null. null is only allowed if the model has a single Signature. Available Signatures: " + Arrays.toString(this.signatureNameList));
        }
        this.wrapper.runSignature(inputs, outputs, methodName);
    }

    public void runSignature(@NonNull Map<String, Object> inputs, @NonNull Map<String, Object> outputs) {
        this.checkNotClosed();
        this.runSignature(inputs, outputs, null);
    }

    public void allocateTensors() {
        this.checkNotClosed();
        this.wrapper.allocateTensors();
    }

    public void resizeInput(int idx, @NonNull int[] dims) {
        this.checkNotClosed();
        this.wrapper.resizeInput(idx, dims, false);
    }

    public void resizeInput(int idx, @NonNull int[] dims, boolean strict) {
        this.checkNotClosed();
        this.wrapper.resizeInput(idx, dims, strict);
    }

    public int getInputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getInputTensorCount();
    }

    public int getInputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getInputIndex(opName);
    }

    public Tensor getInputTensor(int inputIndex) {
        this.checkNotClosed();
        return this.wrapper.getInputTensor(inputIndex);
    }

    public Tensor getInputTensorFromSignature(String inputName, String methodName) {
        this.checkNotClosed();
        if (methodName == null && this.signatureNameList.length == 1) {
            methodName = this.signatureNameList[0];
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Input error: SignatureDef methodName should not be null. null is only allowed if the model has a single Signature. Available Signatures: " + Arrays.toString(this.signatureNameList));
        }
        return this.wrapper.getInputTensor(inputName, methodName);
    }

    public String[] getSignatureDefNames() {
        this.checkNotClosed();
        return this.wrapper.getSignatureDefNames();
    }

    public String[] getSignatureInputs(String methodName) {
        this.checkNotClosed();
        return this.wrapper.getSignatureInputs(methodName);
    }

    public String[] getSignatureOutputs(String methodName) {
        this.checkNotClosed();
        return this.wrapper.getSignatureOutputs(methodName);
    }

    public int getOutputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getOutputTensorCount();
    }

    public int getOutputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getOutputIndex(opName);
    }

    public Tensor getOutputTensor(int outputIndex) {
        this.checkNotClosed();
        return this.wrapper.getOutputTensor(outputIndex);
    }

    public Tensor getOutputTensorFromSignature(String outputName, String methodName) {
        this.checkNotClosed();
        if (methodName == null && this.signatureNameList.length == 1) {
            methodName = this.signatureNameList[0];
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Input error: SignatureDef methodName should not be null. null is only allowed if the model has a single Signature. Available Signatures: " + Arrays.toString(this.signatureNameList));
        }
        return this.wrapper.getOutputTensor(outputName, methodName);
    }

    public Long getLastNativeInferenceDurationNanoseconds() {
        this.checkNotClosed();
        return this.wrapper.getLastNativeInferenceDurationNanoseconds();
    }

    @Deprecated
    public void setNumThreads(int numThreads) {
        this.checkNotClosed();
        this.wrapper.setNumThreads(numThreads);
    }

    @Deprecated
    public void modifyGraphWithDelegate(Delegate delegate) {
        this.checkNotClosed();
        this.wrapper.modifyGraphWithDelegate(delegate);
    }

    public void resetVariableTensors() {
        this.checkNotClosed();
        this.wrapper.resetVariableTensors();
    }

    public void setCancelled(boolean cancelled) {
        this.wrapper.setCancelled(cancelled);
    }

    int getExecutionPlanLength() {
        this.checkNotClosed();
        return this.wrapper.getExecutionPlanLength();
    }

    @Override
    public void close() {
        if (this.wrapper != null) {
            this.wrapper.close();
            this.wrapper = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void checkNotClosed() {
        if (this.wrapper == null) {
            throw new IllegalStateException("Internal error: The Interpreter has already been closed.");
        }
    }

    public static class Options {
        int numThreads = -1;
        Boolean useNNAPI;
        Boolean allowFp16PrecisionForFp32;
        Boolean allowBufferHandleOutput;
        Boolean allowCancellation;
        Boolean useXNNPACK;
        final List<Delegate> delegates = new ArrayList<Delegate>();

        public Options setNumThreads(int numThreads) {
            this.numThreads = numThreads;
            return this;
        }

        public Options setUseNNAPI(boolean useNNAPI) {
            this.useNNAPI = useNNAPI;
            return this;
        }

        @Deprecated
        public Options setAllowFp16PrecisionForFp32(boolean allow) {
            this.allowFp16PrecisionForFp32 = allow;
            return this;
        }

        public Options addDelegate(Delegate delegate) {
            this.delegates.add(delegate);
            return this;
        }

        public Options setAllowBufferHandleOutput(boolean allow) {
            this.allowBufferHandleOutput = allow;
            return this;
        }

        public Options setCancellable(boolean allow) {
            this.allowCancellation = allow;
            return this;
        }

        public Options setUseXNNPACK(boolean useXNNPACK) {
            this.useXNNPACK = useXNNPACK;
            return this;
        }
    }
}

