/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import org.tentackle.buildsupport.ResourceManager;

public abstract class AbstractTentackleProcessor
extends AbstractProcessor {
    private File sourceDir;
    private final Map<File, ResourceManager> resourceManagers = new HashMap<File, ResourceManager>();
    private boolean debugLogging;
    private boolean infoLogging;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String verbosity = processingEnv.getOptions().get("verbosity");
        if (verbosity != null) {
            if ("info".equalsIgnoreCase(verbosity)) {
                this.infoLogging = true;
            } else if ("debug".equalsIgnoreCase(verbosity)) {
                this.debugLogging = true;
                this.infoLogging = true;
            }
        }
    }

    public boolean isInfoLogging() {
        return this.infoLogging;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }

    public ResourceManager getResourceManager(File directory) {
        return this.resourceManagers.computeIfAbsent(directory, ResourceManager::new);
    }

    public Collection<ResourceManager> getResourceManagers() {
        return this.resourceManagers.values();
    }

    public void cleanup() throws IOException {
        for (ResourceManager resourceManager : this.resourceManagers.values()) {
            resourceManager.close();
        }
        this.resourceManagers.clear();
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }
}

