/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.buildsupport.AbstractTentackleProcessor;
import org.tentackle.buildsupport.AnalyzeHandler;
import org.tentackle.common.Analyze;
import org.tentackle.common.TentackleRuntimeException;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"verbosity"})
public class AnalyzeProcessor
extends AbstractTentackleProcessor {
    public static final String COMPILE_ERROR_LOG = "error.log";
    private static final int MAX_HANDLERS = 1000;
    private static final int MAX_DEPTH = 100;
    private static final String ANALYZE_CLASSNAME = Analyze.class.getName();
    private File analyzeDir;
    private File serviceDir;
    private ClassLoader processingClassLoader;

    public ClassLoader getProcessingClassLoader() {
        return this.processingClassLoader == null ? this.getClass().getClassLoader() : this.processingClassLoader;
    }

    public void setProcessingClassLoader(ClassLoader processingClassLoader) {
        this.processingClassLoader = processingClassLoader;
    }

    public File getAnalyzeDir() {
        return this.analyzeDir;
    }

    public void setAnalyzeDir(File outputDir) {
        this.analyzeDir = outputDir;
    }

    public File getServiceDir() {
        return this.serviceDir;
    }

    public void setServiceDir(File serviceDir) {
        this.serviceDir = serviceDir;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotationTypes, RoundEnvironment roundEnv) {
        boolean claimed = false;
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotationTypes) {
                if (this.isDebugLogging()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "processing annotation " + typeElement);
                }
                ArrayList<AnalyzeHandler> handlers = new ArrayList<AnalyzeHandler>();
                this.findHandlers(typeElement, handlers, 0);
                for (AnalyzeHandler handler : handlers) {
                    handler.processAnnotation(typeElement, roundEnv);
                    claimed = true;
                }
            }
        }
        return claimed;
    }

    private void findHandlers(TypeElement annotationType, List<AnalyzeHandler> handlers, int depth) {
        if (!annotationType.toString().startsWith("java.lang.")) {
            for (AnnotationMirror annotationMirror : annotationType.getAnnotationMirrors()) {
                if (annotationMirror.getAnnotationType().toString().equals(ANALYZE_CLASSNAME)) {
                    Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParameters = annotationMirror.getElementValues();
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParameters.entrySet()) {
                        ExecutableElement elem = entry.getKey();
                        AnnotationValue anno = entry.getValue();
                        if (!elem.toString().equals("value()")) continue;
                        String handlerClassName = anno.getValue().toString();
                        int ndx = handlerClassName.lastIndexOf(".class");
                        if (ndx > 0) {
                            handlerClassName = handlerClassName.substring(0, ndx);
                        }
                        try {
                            Class<?> handlerClass = Class.forName(handlerClassName);
                            AnalyzeHandler handler = (AnalyzeHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            handler.setProcessor(this);
                            handlers.add(handler);
                            if (handlers.size() <= 1000) continue;
                            throw new TentackleRuntimeException("endless-loop detected while processing " + handlerClass);
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                            throw new TentackleRuntimeException("cannot instantiate AnalyzeHandler " + handlerClassName, (Throwable)ex);
                        }
                    }
                    continue;
                }
                TypeElement parentAnnotation = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (++depth > 100) {
                    this.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, "annotation-loop detected while processing " + parentAnnotation + " -> ignored", annotationType);
                    return;
                }
                this.findHandlers(parentAnnotation, handlers, depth);
            }
        }
    }
}

