/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class AnnotationProcessingHelper {
    public static Modifier[] readModifiers(StringTokenizer stok) {
        ArrayList<Modifier> modList = new ArrayList<Modifier>();
        while (stok.hasMoreTokens()) {
            try {
                modList.add(Modifier.valueOf(stok.nextToken().toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return modList.toArray(new Modifier[0]);
    }

    public static boolean isModifierSet(Modifier modifier, Modifier[] modifierList) {
        boolean rv = false;
        if (modifierList != null) {
            for (Modifier m : modifierList) {
                if (!m.equals((Object)modifier)) continue;
                rv = true;
                break;
            }
        }
        return rv;
    }

    public static String objectArrayToString(Object[] objArray, String separator) {
        StringBuilder buf = new StringBuilder();
        if (objArray != null) {
            boolean addSeparator = false;
            for (Object obj : objArray) {
                if (addSeparator) {
                    buf.append(separator);
                }
                buf.append(obj.toString());
                addSeparator = true;
            }
        }
        return buf.toString();
    }

    public static boolean isTypeInstanceOf(ProcessingEnvironment processingEnv, TypeMirror typeMirror, String className, String genType) {
        String typeName;
        boolean genTypeOk = true;
        if (typeMirror instanceof DeclaredType) {
            typeName = ((DeclaredType)typeMirror).asElement().toString();
            if (genType != null) {
                genTypeOk = false;
                for (TypeMirror typeMirror2 : ((DeclaredType)typeMirror).getTypeArguments()) {
                    if (!AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, typeMirror2, genType)) continue;
                    genTypeOk = true;
                    break;
                }
            }
        } else {
            typeName = typeMirror.toString();
        }
        if (typeName.equals(className)) {
            return genTypeOk;
        }
        for (TypeMirror typeMirror3 : processingEnv.getTypeUtils().directSupertypes(typeMirror)) {
            if (!AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, typeMirror3, className, genType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTypeInstanceOf(ProcessingEnvironment processingEnv, TypeMirror typeMirror, String className) {
        return AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, typeMirror, className, null);
    }

    private AnnotationProcessingHelper() {
    }
}

