/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.IOException;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.buildsupport.AbstractAnalyzeHandler;
import org.tentackle.buildsupport.AnalyzeProcessor;

public class BundleAnalyzeHandler
extends AbstractAnalyzeHandler {
    private AnalyzeProcessor processor;

    @Override
    public void setProcessor(AnalyzeProcessor processor) {
        this.processor = processor;
    }

    @Override
    public AnalyzeProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void processAnnotation(TypeElement annotationType, RoundEnvironment roundEnv) {
        String annotationName = annotationType.toString();
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            if (element.getKind().equals((Object)ElementKind.CLASS) || element.getKind().equals((Object)ElementKind.INTERFACE)) {
                Object bundleName = this.getBundleName(element, annotationName);
                if (bundleName == null) continue;
                String clsName = this.xlateBundleName(element.toString());
                if (!((String)bundleName).equals(clsName)) {
                    bundleName = (String)bundleName + " = " + clsName;
                }
                String fileName = "META-INF/bundles/" + annotationName;
                if (this.processor.isDebugLogging()) {
                    this.print(Diagnostic.Kind.NOTE, "appending '" + (String)bundleName + "' to " + fileName, element);
                }
                try {
                    this.processor.getResourceManager(this.processor.getServiceDir()).getWriter(fileName).println((String)bundleName);
                    continue;
                }
                catch (IOException ex) {
                    this.print(Diagnostic.Kind.ERROR, "file generation error: " + ex, element);
                    return;
                }
            }
            this.print(Diagnostic.Kind.ERROR, "annotated element '" + element + "' is not a class or interface", element);
        }
    }

    protected String getBundleName(Element element, String annotationName) {
        String bundleName = element.toString();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationName)) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String value;
                String arg = entry.getKey().getSimpleName().toString();
                if ("value".equals(arg)) {
                    bundleName = entry.getValue().toString();
                    continue;
                }
                if (!"noBundle".equals(arg) || !"true".equals(value = entry.getValue().toString())) continue;
                bundleName = null;
            }
        }
        return this.xlateBundleName(bundleName);
    }

    protected String xlateBundleName(String bundleName) {
        if (bundleName != null && !bundleName.isEmpty()) {
            if (bundleName.length() > 2 && bundleName.charAt(0) == '\"' && bundleName.charAt(bundleName.length() - 1) == '\"') {
                bundleName = bundleName.substring(1, bundleName.length() - 1);
            }
            if (bundleName.endsWith(".properties")) {
                bundleName = bundleName.substring(0, bundleName.length() - ".properties".length());
            }
            if (bundleName.charAt(0) == '/') {
                bundleName = bundleName.substring(1);
            }
            if ((bundleName = bundleName.replace('/', '.')).endsWith(".class")) {
                bundleName = bundleName.substring(0, bundleName.length() - 6);
            }
        }
        return bundleName;
    }
}

