/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.IOException;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.buildsupport.AbstractAnalyzeHandler;
import org.tentackle.buildsupport.AnalyzeProcessor;

public class InterceptionAnalyzeHandler
extends AbstractAnalyzeHandler {
    private static final String ANNO_NAME = "org.tentackle.reflect.Interception";
    private static final String ALL_TYPE = "ALL";
    private static final String PUBLIC_TYPE = "PUBLIC";
    private static final String HIDDEN_TYPE = "HIDDEN";
    private static final String ALL_APT = "org.tentackle.apt.AllInterceptorAnnotationProcessor";
    private static final String PUBLIC_APT = "org.tentackle.apt.PublicInterceptorAnnotationProcessor";
    private static final String HIDDEN_APT = "org.tentackle.apt.HiddenInterceptorAnnotationProcessor";
    private AnalyzeProcessor processor;

    @Override
    public void setProcessor(AnalyzeProcessor processor) {
        this.processor = processor;
    }

    @Override
    public AnalyzeProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void processAnnotation(TypeElement annotationType, RoundEnvironment roundEnv) {
        String annotationName = annotationType.toString();
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (!element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            String interceptorName = element.toString();
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                String annoName = annotationMirror.getAnnotationType().toString();
                if (!ANNO_NAME.equals(annoName)) continue;
                String aptName = ALL_APT;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    String argName = entry.getKey().getSimpleName().toString();
                    if (!"type".equals(argName)) continue;
                    String typeStr = entry.getValue().toString();
                    String processorName = null;
                    if (typeStr.contains(ALL_TYPE)) {
                        processorName = ALL_APT;
                    } else if (typeStr.contains(PUBLIC_TYPE)) {
                        processorName = PUBLIC_APT;
                    } else if (typeStr.contains(HIDDEN_TYPE)) {
                        processorName = HIDDEN_APT;
                    }
                    if (processorName == null) {
                        this.print(Diagnostic.Kind.ERROR, "invalid interceptor type '" + typeStr + "'", element);
                        return;
                    }
                    aptName = processorName;
                }
                String relativeName = "META-INF/services/" + aptName;
                if (this.processor.isDebugLogging()) {
                    this.print(Diagnostic.Kind.NOTE, "appending '" + interceptorName + "' to " + relativeName, element);
                }
                try {
                    this.processor.getResourceManager(this.processor.getServiceDir()).getWriter(relativeName).println(interceptorName);
                    this.processor.getResourceManager(this.processor.getAnalyzeDir()).getWriter(interceptorName.replace('.', '/') + "/service.log").println(aptName);
                }
                catch (IOException ex) {
                    this.print(Diagnostic.Kind.ERROR, "file generation error: " + ex, element);
                    return;
                }
            }
        }
    }
}

