/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.IOException;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.buildsupport.AbstractAnalyzeHandler;
import org.tentackle.buildsupport.AnalyzeProcessor;
import org.tentackle.common.MappedService;
import org.tentackle.common.StringHelper;

public class MappedServiceAnalyzeHandler
extends AbstractAnalyzeHandler {
    private static final String ANNOTATION_NAME = MappedService.class.getName();
    private AnalyzeProcessor processor;

    @Override
    public void setProcessor(AnalyzeProcessor processor) {
        this.processor = processor;
    }

    @Override
    public AnalyzeProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void processAnnotation(TypeElement annotationType, RoundEnvironment roundEnv) {
        String annotationName = annotationType.toString();
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            if (element.getKind().equals((Object)ElementKind.CLASS) || element.getKind().equals((Object)ElementKind.INTERFACE)) {
                String servicingClassName = element.toString();
                String serviceClassName = null;
                String methodName = "value";
                for (AnnotationMirror annotationMirror : annotationType.getAnnotationMirrors()) {
                    if (!annotationMirror.getAnnotationType().toString().equals(ANNOTATION_NAME)) continue;
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        if ("value".equals(entry.getKey().getSimpleName().toString())) {
                            serviceClassName = ((AnnotationValue)entry.getValue()).toString();
                            int ndx = serviceClassName.lastIndexOf(".class");
                            if (ndx < 0) continue;
                            serviceClassName = serviceClassName.substring(0, ndx);
                            continue;
                        }
                        if (!"method".equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())) continue;
                        methodName = StringHelper.parseString((String)((AnnotationValue)entry.getValue()).toString());
                    }
                }
                if (serviceClassName == null) {
                    this.print(Diagnostic.Kind.ERROR, "no '" + methodName + "' method in @" + StringHelper.lastAfter((String)ANNOTATION_NAME, (char)'.'), element);
                    continue;
                }
                String servicedClassName = null;
                block5: for (AnnotationMirror annoMirror3 : element.getAnnotationMirrors()) {
                    Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry;
                    if (!annoMirror3.getAnnotationType().toString().equals(annotationName)) continue;
                    entry = annoMirror3.getElementValues().entrySet().iterator();
                    while (entry.hasNext()) {
                        Map.Entry entry2 = (Map.Entry)entry.next();
                        if (!methodName.equals(((ExecutableElement)entry2.getKey()).getSimpleName().toString())) continue;
                        servicedClassName = ((AnnotationValue)entry2.getValue()).toString();
                        int ndx = servicedClassName.lastIndexOf(".class");
                        if (ndx < 0) break block5;
                        servicedClassName = servicedClassName.substring(0, ndx);
                        break block5;
                    }
                    break block5;
                }
                if (servicedClassName == null) {
                    this.print(Diagnostic.Kind.ERROR, "cannot determine " + serviceClassName + " via @" + StringHelper.lastAfter((String)ANNOTATION_NAME, (char)'.') + "#" + methodName, element);
                    continue;
                }
                String string = servicingClassName + " = " + servicedClassName;
                String relativeName = "META-INF/mapped-services/" + serviceClassName;
                if (this.processor.isDebugLogging()) {
                    this.print(Diagnostic.Kind.NOTE, "appending '" + string + "' to " + relativeName, element);
                }
                try {
                    this.processor.getResourceManager(this.processor.getServiceDir()).getWriter(relativeName).println(string);
                    this.processor.getResourceManager(this.processor.getAnalyzeDir()).getWriter(servicingClassName.replace('.', '/') + "/service.log").println(serviceClassName + ": " + string);
                    continue;
                }
                catch (IOException ex) {
                    this.print(Diagnostic.Kind.ERROR, "file generation error: " + ex, element);
                    return;
                }
            }
            this.print(Diagnostic.Kind.ERROR, "annotated element '" + element + "' is not a class or interface", element);
        }
    }
}

