/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.buildsupport.AbstractAnalyzeHandler;
import org.tentackle.buildsupport.AnalyzeProcessor;
import org.tentackle.buildsupport.RecordDTOInfo;
import org.tentackle.common.Settings;

public class RecordDTOAnalyzeHandler
extends AbstractAnalyzeHandler {
    private AnalyzeProcessor processor;

    @Override
    public void setProcessor(AnalyzeProcessor processor) {
        this.processor = processor;
    }

    @Override
    public AnalyzeProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void processAnnotation(TypeElement annotationType, RoundEnvironment roundEnv) {
        Class<?> annotationClass;
        try {
            annotationClass = Class.forName(annotationType.toString());
        }
        catch (ClassNotFoundException nfe) {
            this.print(Diagnostic.Kind.ERROR, "cannot load annotation class " + annotationType + ": " + nfe, annotationType);
            return;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            if (element.getKind().equals((Object)ElementKind.RECORD)) {
                TypeElement recordElement = (TypeElement)element;
                String recordName = recordElement.toString();
                Object annotation = recordElement.getAnnotation(annotationClass);
                if (this.getProcessor().isDebugLogging()) {
                    this.print(Diagnostic.Kind.NOTE, "found annotated record " + recordName, element);
                }
                try {
                    RecordDTOInfo info = new RecordDTOInfo(this.getProcessor().getProcessingEnvironment(), recordElement);
                    File outputDir = this.getDirectory(this.getProcessor().getAnalyzeDir(), recordName);
                    outputDir.mkdirs();
                    File outputFile = new File(outputDir, "record.info");
                    try (PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), Settings.getEncodingCharset())));){
                        info.write(pw);
                    }
                    if (!this.getProcessor().isDebugLogging()) continue;
                    this.print(Diagnostic.Kind.NOTE, "created " + outputFile, element);
                }
                catch (IOException ex) {
                    this.print(Diagnostic.Kind.ERROR, "extracting RecordDTOInfo failed: " + ex, element);
                }
                continue;
            }
            this.print(Diagnostic.Kind.WARNING, "annotated element '" + element + "' is not a record -> ignored", element);
        }
    }
}

