/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import org.tentackle.buildsupport.AnnotationProcessingHelper;
import org.tentackle.buildsupport.RecordDTOInfoParameter;
import org.tentackle.common.Settings;

public class RecordDTOInfo {
    public static final String INFO_FILE_VERSION = "1.0";
    public static final String INFO_FILE_NAME = "record.info";
    private static final String TYPE = "type";
    private static final String ARG = "arg[";
    private String recordName;
    private List<RecordDTOInfoParameter> parameterList;

    public static RecordDTOInfo readInfo(File infoFile) throws IOException {
        RecordDTOInfo info;
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(infoFile), Settings.getEncodingCharset()));){
            info = RecordDTOInfo.readInfo(reader);
        }
        return info;
    }

    public static RecordDTOInfo readInfo(LineNumberReader reader) throws IOException {
        String line;
        RecordDTOInfo info = null;
        while ((line = reader.readLine()) != null) {
            StringTokenizer stok;
            if (line.startsWith("#") || !(stok = new StringTokenizer(line, ":")).hasMoreTokens()) continue;
            String type = stok.nextToken();
            if (info == null) {
                info = new RecordDTOInfo();
            }
            if (!stok.hasMoreTokens()) continue;
            String text = stok.nextToken();
            stok = new StringTokenizer(text);
            if (TYPE.equals(type)) {
                info.setRecordName(text);
                continue;
            }
            if (!type.startsWith(ARG)) continue;
            info.addParameter(new RecordDTOInfoParameter(info, stok));
        }
        return info;
    }

    public RecordDTOInfo() {
    }

    public RecordDTOInfo(ProcessingEnvironment processingEnv, TypeElement recordElement) {
        this.setRecordName(recordElement.toString());
        for (RecordComponentElement recordComponentElement : recordElement.getRecordComponents()) {
            this.addParameter(new RecordDTOInfoParameter(this, recordComponentElement));
        }
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public RecordDTOInfoParameter[] getParameters() {
        return this.parameterList == null ? null : this.parameterList.toArray(new RecordDTOInfoParameter[0]);
    }

    public void addParameter(RecordDTOInfoParameter parameter) {
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<RecordDTOInfoParameter>();
        }
        this.parameterList.add(parameter);
    }

    public String toString() {
        return this.getRecordName() + "(" + AnnotationProcessingHelper.objectArrayToString(this.getParameters(), ", ") + ")";
    }

    public void write(PrintWriter writer) {
        writer.println("# " + this.getClass().getName() + " Version 1.0");
        writer.println("# " + this);
        writer.println("type: " + this.recordName);
        if (this.parameterList != null) {
            int argc = 0;
            for (RecordDTOInfoParameter par : this.parameterList) {
                writer.print(ARG + argc++ + "]: ");
                par.write(writer);
                writer.println();
            }
        }
    }
}

