/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.buildsupport.AbstractAnalyzeHandler;
import org.tentackle.buildsupport.AnalyzeProcessor;
import org.tentackle.buildsupport.RemoteMethodInfo;
import org.tentackle.common.Settings;
import org.tentackle.common.StringHelper;

public class RemoteMethodAnalyzeHandler
extends AbstractAnalyzeHandler {
    private AnalyzeProcessor processor;

    @Override
    public void setProcessor(AnalyzeProcessor processor) {
        this.processor = processor;
    }

    @Override
    public AnalyzeProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void processAnnotation(TypeElement annotationType, RoundEnvironment roundEnv) {
        Class<?> annotationClass;
        try {
            annotationClass = Class.forName(annotationType.toString());
        }
        catch (ClassNotFoundException nfe) {
            this.print(Diagnostic.Kind.ERROR, "cannot load annotation class " + annotationType + ": " + nfe, annotationType);
            return;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            if (element.getKind().equals((Object)ElementKind.METHOD)) {
                ExecutableElement methodElement = (ExecutableElement)element;
                Element enclosingElement = methodElement.getEnclosingElement();
                if (enclosingElement != null && enclosingElement.getKind().equals((Object)ElementKind.CLASS)) {
                    CharSequence methodName;
                    String className;
                    block15: {
                        className = enclosingElement.toString();
                        Object annotation = methodElement.getAnnotation(annotationClass);
                        methodName = methodElement.getSimpleName();
                        try {
                            Method valueMethod = annotationClass.getDeclaredMethod("value", new Class[0]);
                            String value = (String)valueMethod.invoke(annotation, new Object[0]);
                            if ("[methodname]".equals(value)) break block15;
                            methodName = value;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException nme) {
                            this.print(Diagnostic.Kind.ERROR, "no value method for @" + StringHelper.lastAfter((String)annotationClass.getName(), (char)'.'), element);
                            continue;
                        }
                    }
                    if (this.getProcessor().isDebugLogging()) {
                        this.print(Diagnostic.Kind.NOTE, "found annotated method " + methodName + " in class " + className, element);
                    }
                    try {
                        RemoteMethodInfo info = new RemoteMethodInfo(this.getProcessor().getProcessingEnvironment(), methodElement);
                        File outputDir = this.getDirectory(this.getProcessor().getAnalyzeDir(), className);
                        outputDir.mkdirs();
                        File outputFile = new File(outputDir, methodName + ".remote");
                        try (PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), Settings.getEncodingCharset())));){
                            info.write(pw);
                        }
                        if (!this.getProcessor().isDebugLogging()) continue;
                        this.print(Diagnostic.Kind.NOTE, "created " + outputFile, element);
                    }
                    catch (IOException ex) {
                        this.print(Diagnostic.Kind.ERROR, "extracting RemoteMethodInfo failed: " + ex, element);
                    }
                    continue;
                }
                this.print(Diagnostic.Kind.WARNING, "enclosing element '" + enclosingElement + "' of annotated method '" + methodElement.getSimpleName() + "' is not a class -> ignored", element);
                continue;
            }
            this.print(Diagnostic.Kind.WARNING, "annotated element '" + element + "' is not a method -> ignored", element);
        }
    }
}

