/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.tentackle.buildsupport.AnnotationProcessingHelper;
import org.tentackle.buildsupport.RemoteMethodInfoParameter;
import org.tentackle.common.Settings;

public class RemoteMethodInfo {
    public static final String INFO_FILE_VERSION = "2.0";
    public static final String INFO_FILE_EXTENSION = ".remote";
    public static final String TYPE_METHOD = "method";
    public static final String TYPE_CLASS = "class";
    private static final String NAME_PART = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern FQCN_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");
    private final String nameCollection;
    private final String nameSession;
    private final String nameDbObject;
    private final String nameCursor;
    private final String nameContext;
    private final String namePdo;
    private final String type;
    private String className;
    private String superClassName;
    private String methodName;
    private String returnType;
    private String genericReturnType;
    private boolean returningDbObject;
    private boolean returningDbObjectCollection;
    private boolean returningPdo;
    private boolean returningPdoCollection;
    private boolean returningPdoCursor;
    private boolean returningCursor;
    private List<RemoteMethodInfoParameter> parameterList;
    private boolean varArgsMethod;
    private Modifier[] modifiers;

    public static RemoteMethodInfo readInfo(File infoFile) throws IOException {
        RemoteMethodInfo info;
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(infoFile), Settings.getEncodingCharset()));){
            info = RemoteMethodInfo.readInfo(reader);
        }
        return info;
    }

    public static RemoteMethodInfo readInfo(LineNumberReader reader) throws IOException {
        String line;
        RemoteMethodInfo info = null;
        while ((line = reader.readLine()) != null) {
            StringTokenizer stok;
            if (line.startsWith("#") || !(stok = new StringTokenizer(line, ":")).hasMoreTokens()) continue;
            String type = stok.nextToken();
            if (info == null) {
                info = new RemoteMethodInfo(type);
            }
            if (!stok.hasMoreTokens()) continue;
            String text = stok.nextToken();
            stok = new StringTokenizer(text);
            if (type.equals(TYPE_METHOD)) {
                info.setMethodName(stok.nextToken());
                continue;
            }
            if (type.equals(TYPE_CLASS)) {
                info.setClassName(stok.nextToken());
                continue;
            }
            if (type.equals("superclass")) {
                info.setSuperClassName(stok.nextToken());
                continue;
            }
            if (type.equals("returns")) {
                info.setReturnType(stok.nextToken());
                String gType = stok.nextToken();
                info.setGenericReturnType(gType.equals(".") ? "" : gType);
                info.setReturningDbObject(Boolean.parseBoolean(stok.nextToken()));
                info.setReturningDbObjectCollection(Boolean.parseBoolean(stok.nextToken()));
                info.setReturningPdo(Boolean.parseBoolean(stok.nextToken()));
                info.setReturningPdoCollection(Boolean.parseBoolean(stok.nextToken()));
                info.setReturningPdoCursor(Boolean.parseBoolean(stok.nextToken()));
                info.setReturningCursor(Boolean.parseBoolean(stok.nextToken()));
                continue;
            }
            if (type.equals("modifiers")) {
                info.setModifiers(AnnotationProcessingHelper.readModifiers(stok));
                continue;
            }
            if (type.equals("varargs")) {
                info.setVarArgsMethod(Boolean.parseBoolean(stok.nextToken()));
                continue;
            }
            if (!type.startsWith("arg")) continue;
            info.addParameter(new RemoteMethodInfoParameter(info, stok));
        }
        if (info != null && info.getType().equals(TYPE_METHOD) && info.isVarArgsMethod()) {
            info.parameterList.get(info.parameterList.size() - 1).setVarArg(true);
        }
        return info;
    }

    public RemoteMethodInfo(String type) throws IOException {
        ResourceBundle bundle = ResourceBundle.getBundle("org.tentackle.buildsupport.ClassNames");
        this.nameCollection = bundle.getString("CLASSNAME_COLLECTION");
        this.nameSession = bundle.getString("CLASSNAME_SESSION");
        this.nameDbObject = bundle.getString("CLASSNAME_DBOBJECT");
        this.nameCursor = bundle.getString("CLASSNAME_CURSOR");
        this.nameContext = bundle.getString("CLASSNAME_CONTEXT");
        this.namePdo = bundle.getString("CLASSNAME_PDO");
        if (!type.equals(TYPE_METHOD)) {
            throw new IOException("unsupported type '" + type + "'");
        }
        this.type = type;
    }

    public RemoteMethodInfo(ProcessingEnvironment processingEnv, ExecutableElement methodElement) throws IOException {
        this(TYPE_METHOD);
        int ndx2;
        Element classElement = methodElement.getEnclosingElement();
        this.setClassName(classElement.toString());
        try {
            this.setSuperClassName(((TypeElement)classElement).getSuperclass().toString());
        }
        catch (RuntimeException ex) {
            this.setSuperClassName(null);
        }
        this.setMethodName(methodElement.getSimpleName().toString());
        TypeMirror tm = methodElement.getReturnType();
        this.setReturnType(tm.toString());
        this.setGenericReturnType("");
        int ndx1 = this.getReturnType().indexOf(60);
        if (ndx1 > 0 && (ndx2 = this.getReturnType().indexOf(62, ndx1)) > ndx1) {
            this.setGenericReturnType(this.getReturnType().substring(ndx1, ndx2 + 1));
        }
        this.setReturningPdo(AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, this.namePdo));
        this.setReturningPdoCollection(AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, this.nameCollection, this.namePdo));
        this.setReturningPdoCursor(AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, this.nameCursor, this.namePdo));
        if (this.isReturningPdo()) {
            this.setReturningDbObject(true);
        } else {
            this.setReturningDbObject(AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, this.nameDbObject));
        }
        if (this.isReturningPdoCollection()) {
            this.setReturningDbObjectCollection(true);
        } else {
            this.setReturningDbObjectCollection(AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, this.nameCollection, this.nameDbObject));
        }
        if (this.isReturningPdoCursor()) {
            this.setReturningCursor(true);
        } else {
            this.setReturningCursor(AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, this.nameCursor));
        }
        Set<Modifier> methodElementModifiers = methodElement.getModifiers();
        this.setModifiers(methodElementModifiers.toArray(new Modifier[0]));
        this.varArgsMethod = methodElement.isVarArgs();
        List<? extends VariableElement> varList = methodElement.getParameters();
        for (int i = 0; i < varList.size(); ++i) {
            RemoteMethodInfoParameter par = new RemoteMethodInfoParameter(this, processingEnv, varList.get(i));
            if (i == varList.size() - 1) {
                par.setVarArg(this.varArgsMethod);
            }
            this.addParameter(par);
        }
    }

    public String getNameCollection() {
        return this.nameCollection;
    }

    public String getNameSession() {
        return this.nameSession;
    }

    public String getNameDbObject() {
        return this.nameDbObject;
    }

    public String getNameCursor() {
        return this.nameCursor;
    }

    public String getNameContext() {
        return this.nameContext;
    }

    public String getNamePdo() {
        return this.namePdo;
    }

    public String getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getGenericReturnType() {
        return this.genericReturnType;
    }

    public void setGenericReturnType(String genericReturnType) {
        this.genericReturnType = genericReturnType;
    }

    public RemoteMethodInfoParameter[] getParameters() {
        return this.parameterList == null ? null : this.parameterList.toArray(new RemoteMethodInfoParameter[0]);
    }

    public void addParameter(RemoteMethodInfoParameter parameter) {
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<RemoteMethodInfoParameter>();
        }
        this.parameterList.add(parameter);
    }

    public boolean isVarArgsMethod() {
        return this.varArgsMethod;
    }

    public void setVarArgsMethod(boolean varArgsMethod) {
        this.varArgsMethod = varArgsMethod;
    }

    public Modifier[] getModifiers() {
        return this.modifiers;
    }

    public String getModifiersAsString() {
        return AnnotationProcessingHelper.objectArrayToString((Object[])this.modifiers, " ");
    }

    public boolean isModifierSet(Modifier modifier) {
        return AnnotationProcessingHelper.isModifierSet(modifier, this.modifiers);
    }

    public void setModifiers(Modifier[] modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isReturningDbObject() {
        return this.returningDbObject;
    }

    public void setReturningDbObject(boolean returningDbObject) {
        this.returningDbObject = returningDbObject;
    }

    public boolean isReturningDbObjectCollection() {
        return this.returningDbObjectCollection;
    }

    public void setReturningDbObjectCollection(boolean returningDbObjectCollection) {
        this.returningDbObjectCollection = returningDbObjectCollection;
    }

    public boolean isReturningCursor() {
        return this.returningCursor;
    }

    public void setReturningCursor(boolean returningCursor) {
        this.returningCursor = returningCursor;
    }

    public boolean isReturningPdoCursor() {
        return this.returningPdoCursor;
    }

    public void setReturningPdoCursor(boolean returningPdoCursor) {
        this.returningPdoCursor = returningPdoCursor;
    }

    public boolean isReturningPdo() {
        return this.returningPdo;
    }

    public void setReturningPdo(boolean returningPdo) {
        this.returningPdo = returningPdo;
    }

    public boolean isReturningPdoCollection() {
        return this.returningPdoCollection;
    }

    public void setReturningPdoCollection(boolean returningPdoCollection) {
        this.returningPdoCollection = returningPdoCollection;
    }

    public String toString() {
        if (this.type.equals(TYPE_METHOD)) {
            return this.getModifiersAsString() + " " + this.getReturnType() + " " + this.getMethodName() + "(" + AnnotationProcessingHelper.objectArrayToString(this.getParameters(), ", ") + ")";
        }
        return "";
    }

    public void write(PrintWriter writer) throws IOException {
        if (this.type.equals(TYPE_METHOD)) {
            writer.println("# " + this.getClass().getName() + " Version 2.0");
            writer.println("# " + this);
            writer.println("method: " + this.methodName);
            writer.println("class: " + this.className);
            if (this.superClassName != null) {
                writer.println("superclass: " + this.superClassName);
            }
            writer.println("returns: " + this.returnType + " " + (this.genericReturnType == null || this.genericReturnType.isEmpty() ? "." : this.genericReturnType) + " " + this.returningDbObject + " " + this.returningDbObjectCollection + " " + this.returningPdo + " " + this.returningPdoCollection + " " + this.returningPdoCursor + " " + this.returningCursor);
            writer.println("modifiers: " + this.getModifiersAsString());
            writer.println("varargs: " + this.varArgsMethod);
            if (this.parameterList != null) {
                int argc = 0;
                for (RemoteMethodInfoParameter par : this.parameterList) {
                    writer.print("arg[" + argc++ + "]: ");
                    par.write(writer);
                    writer.println();
                }
            }
        } else {
            throw new IOException("unsupported info type: " + this.type);
        }
    }

    public String cleanTypeString(String type) {
        StringBuilder buf = new StringBuilder();
        Matcher matcher = FQCN_PATTERN.matcher(type);
        int lastNdx = 0;
        while (matcher.find()) {
            buf.append(type, lastNdx, matcher.start());
            String name = type.substring(matcher.start(), matcher.end());
            int dotNdx = name.lastIndexOf(46);
            buf.append(name.substring(dotNdx + 1));
            lastNdx = matcher.end();
        }
        buf.append(type.substring(lastNdx));
        return buf.toString();
    }
}

