/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.PrintWriter;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.tentackle.buildsupport.AnnotationProcessingHelper;
import org.tentackle.buildsupport.RemoteMethodInfo;

public class RemoteMethodInfoParameter {
    private final RemoteMethodInfo info;
    private final String name;
    private final String type;
    private Modifier[] modifiers;
    private boolean instanceOfSession;
    private boolean instanceOfContext;
    private boolean instanceOfDbObject;
    private boolean instanceOfPdo;
    private boolean varArg;

    public RemoteMethodInfoParameter(RemoteMethodInfo info, ProcessingEnvironment processingEnv, VariableElement var) {
        this.info = info;
        TypeMirror tm = var.asType();
        this.name = var.toString();
        this.type = tm.toString();
        Set<Modifier> varModifiers = var.getModifiers();
        this.modifiers = varModifiers.toArray(new Modifier[0]);
        this.instanceOfSession = AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, info.getNameSession());
        this.instanceOfContext = AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, info.getNameContext());
        this.instanceOfPdo = AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, info.getNamePdo());
        this.instanceOfDbObject = this.instanceOfPdo || AnnotationProcessingHelper.isTypeInstanceOf(processingEnv, tm, info.getNameDbObject());
    }

    public RemoteMethodInfoParameter(RemoteMethodInfo info, StringTokenizer stok) {
        this.info = info;
        this.name = stok.nextToken();
        this.type = stok.nextToken();
        this.instanceOfSession = Boolean.parseBoolean(stok.nextToken());
        this.instanceOfContext = Boolean.parseBoolean(stok.nextToken());
        this.instanceOfDbObject = Boolean.parseBoolean(stok.nextToken());
        this.instanceOfPdo = Boolean.parseBoolean(stok.nextToken());
        this.modifiers = AnnotationProcessingHelper.readModifiers(stok);
    }

    public RemoteMethodInfoParameter(RemoteMethodInfo info, String name, String type) {
        this.info = info;
        this.name = name;
        this.type = type;
    }

    public RemoteMethodInfo getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.varArg ? this.type.substring(0, this.type.length() - 2) : this.type;
    }

    public Modifier[] getModifiers() {
        return this.modifiers;
    }

    public boolean isInstanceOfSession() {
        return this.instanceOfSession;
    }

    public boolean isInstanceOfDbObject() {
        return this.instanceOfDbObject;
    }

    public boolean isInstanceOfPdo() {
        return this.instanceOfPdo;
    }

    public String getModifiersAsString() {
        return AnnotationProcessingHelper.objectArrayToString((Object[])this.modifiers, " ");
    }

    public boolean isInstanceOfContext() {
        return this.instanceOfContext;
    }

    public boolean isVarArg() {
        return this.varArg;
    }

    public void setVarArg(boolean varArg) {
        this.varArg = varArg;
    }

    public boolean isModifierSet(Modifier modifier) {
        return AnnotationProcessingHelper.isModifierSet(modifier, this.modifiers);
    }

    public void write(PrintWriter writer) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        buf.append(' ');
        buf.append(this.type);
        buf.append(' ');
        buf.append(this.instanceOfSession);
        buf.append(' ');
        buf.append(this.instanceOfContext);
        buf.append(' ');
        buf.append(this.instanceOfDbObject);
        buf.append(' ');
        buf.append(this.instanceOfPdo);
        String modStr = this.getModifiersAsString();
        if (modStr.length() > 0) {
            buf.append(' ');
            buf.append(modStr);
        }
        writer.print(buf);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getModifiersAsString());
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getType());
        if (this.isVarArg()) {
            buf.append("...");
        }
        buf.append(' ');
        buf.append(this.name);
        return buf.toString();
    }
}

