/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.tentackle.common.Settings;

public class ResourceManager {
    private final File location;
    private final Map<String, Resource> resourceMap;

    public ResourceManager(File location) {
        this.location = location;
        this.resourceMap = new HashMap<String, Resource>();
    }

    public Set<String> getResourceNames() {
        return new HashSet<String>(this.resourceMap.keySet());
    }

    public File getLocation() {
        return this.location;
    }

    public PrintWriter getWriter(String name) throws IOException {
        return this.getResource(name).getWriter();
    }

    public Reader getReader(String name) throws IOException {
        return this.getResource(name).getReader();
    }

    public boolean exists(String name) {
        return this.getResource(name).exists();
    }

    public void close() throws IOException {
        for (Resource resource : this.resourceMap.values()) {
            resource.close();
        }
    }

    private Resource getResource(String name) {
        return this.resourceMap.computeIfAbsent(name, x$0 -> new Resource((String)x$0));
    }

    private class Resource {
        private final String name;
        private File file;
        private PrintWriter writer;
        private Reader reader;

        private Resource(String name) {
            this.name = name;
        }

        private File getFile() {
            if (this.file == null) {
                StringTokenizer stok = new StringTokenizer(this.name, "/");
                File dir = null;
                this.file = ResourceManager.this.location;
                while (stok.hasMoreTokens()) {
                    dir = this.file;
                    this.file = new File(dir, stok.nextToken());
                }
                if (dir != null) {
                    dir.mkdirs();
                }
            }
            return this.file;
        }

        private PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getFile()), Settings.getEncodingCharset())));
            }
            return this.writer;
        }

        private Reader getReader() throws IOException {
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFile()), Settings.getEncodingCharset()));
            }
            return this.reader;
        }

        private void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }

        private boolean exists() {
            return this.getFile().exists();
        }
    }
}

