/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.IOException;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.buildsupport.AbstractAnalyzeHandler;
import org.tentackle.buildsupport.AnalyzeProcessor;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceName;
import org.tentackle.common.StringHelper;

public class ServiceAnalyzeHandler
extends AbstractAnalyzeHandler {
    private static final String SERVICE_CLASS = Service.class.getName();
    private static final String SERVICENAME_CLASS = ServiceName.class.getName();
    private AnalyzeProcessor processor;

    @Override
    public void setProcessor(AnalyzeProcessor processor) {
        this.processor = processor;
    }

    @Override
    public AnalyzeProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void processAnnotation(TypeElement annotationType, RoundEnvironment roundEnv) {
        String annotationName = annotationType.toString();
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            if (element.getKind().equals((Object)ElementKind.CLASS) || element.getKind().equals((Object)ElementKind.INTERFACE)) {
                String servicingClassName = element.toString();
                String servicedClassName = null;
                String methodName = "value";
                boolean meta = false;
                for (AnnotationMirror annotationMirror : annotationType.getAnnotationMirrors()) {
                    String annoName = annotationMirror.getAnnotationType().toString();
                    if (!SERVICE_CLASS.equals(annoName) && !SERVICENAME_CLASS.equals(annoName)) continue;
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        String argName = entry.getKey().getSimpleName().toString();
                        if ("value".equals(argName)) {
                            servicedClassName = this.extractServicedClassName(entry.getValue());
                            continue;
                        }
                        if ("meta".equals(argName)) {
                            meta = true;
                            continue;
                        }
                        if (!"method".equals(entry.getKey().getSimpleName().toString())) continue;
                        methodName = StringHelper.parseString((String)entry.getValue().toString());
                    }
                }
                if (servicedClassName == null || meta) {
                    block5: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                        if (!annotationMirror.getAnnotationType().toString().equals(annotationName)) continue;
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                            if (!methodName.equals(entry.getKey().getSimpleName().toString())) continue;
                            String name = this.extractServicedClassName(entry.getValue());
                            if (meta) {
                                servicingClassName = name;
                                break block5;
                            }
                            servicedClassName = name;
                            break block5;
                        }
                    }
                }
                if (servicedClassName == null) {
                    this.print(Diagnostic.Kind.ERROR, "no '" + methodName + "' method in @" + StringHelper.lastAfter((String)annotationName, (char)'.'), element);
                    continue;
                }
                if (servicedClassName.charAt(0) == '\"' && servicedClassName.length() > 1) {
                    servicedClassName = servicedClassName.substring(1, servicedClassName.length() - 1);
                }
                String relativeName = (meta ? "META-INF/meta-services/" : "META-INF/services/") + servicedClassName;
                if (this.processor.isDebugLogging()) {
                    this.print(Diagnostic.Kind.NOTE, "appending '" + servicingClassName + "' to " + relativeName, element);
                }
                try {
                    this.processor.getResourceManager(this.processor.getServiceDir()).getWriter(relativeName).println(servicingClassName);
                    this.processor.getResourceManager(this.processor.getAnalyzeDir()).getWriter(servicingClassName.replace('.', '/') + "/service.log").println(servicedClassName);
                    continue;
                }
                catch (IOException iOException) {
                    this.print(Diagnostic.Kind.ERROR, "file generation error: " + iOException, element);
                    return;
                }
            }
            this.print(Diagnostic.Kind.ERROR, "annotated element '" + element + "' is not a class", element);
        }
    }

    private String extractServicedClassName(AnnotationValue value) {
        String servicedClassName = value.toString();
        int ndx = servicedClassName.lastIndexOf(".class");
        if (ndx >= 0) {
            servicedClassName = servicedClassName.substring(0, ndx);
        }
        return servicedClassName;
    }
}

