/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.buildsupport;

import java.io.IOException;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.buildsupport.AbstractAnalyzeHandler;
import org.tentackle.buildsupport.AnalyzeProcessor;
import org.tentackle.common.StringHelper;

public class TableNameAnalyzeHandler
extends AbstractAnalyzeHandler {
    private AnalyzeProcessor processor;

    @Override
    public void setProcessor(AnalyzeProcessor processor) {
        this.processor = processor;
    }

    @Override
    public AnalyzeProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void processAnnotation(TypeElement annotationType, RoundEnvironment roundEnv) {
        String annoName = annotationType.toString();
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (element.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) continue;
            if (element.getKind().equals((Object)ElementKind.CLASS) || element.getKind().equals((Object)ElementKind.INTERFACE)) {
                String servicingClassName = element.toString();
                Object tableName = null;
                boolean mapSchema = false;
                String prefix = null;
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    if (!annotationMirror.getAnnotationType().toString().equals(annoName)) continue;
                    block14: for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        String methodName;
                        switch (methodName = entry.getKey().getSimpleName().toString()) {
                            case "value": {
                                tableName = entry.getValue().toString();
                                continue block14;
                            }
                            case "mapSchema": {
                                mapSchema = Boolean.parseBoolean(entry.getValue().toString());
                                continue block14;
                            }
                            case "prefix": {
                                prefix = StringHelper.parseString((String)entry.getValue().toString());
                                if (!StringHelper.isAllWhitespace((String)prefix)) continue block14;
                                prefix = null;
                                continue block14;
                            }
                        }
                        this.print(Diagnostic.Kind.WARNING, "unknown method '" + methodName + "' in annotation " + annotationType, element);
                    }
                }
                if (tableName == null) {
                    this.print(Diagnostic.Kind.ERROR, "no value method in @" + StringHelper.lastAfter((String)annotationType.getClass().getName(), (char)'.'), element);
                    continue;
                }
                if (mapSchema) {
                    tableName = ((String)tableName).replace('.', '_');
                }
                if (prefix != null) {
                    tableName = ((String)tableName).charAt(0) + prefix + ((String)tableName).substring(1);
                }
                String configuration = servicingClassName + " = " + (String)tableName;
                String string = "META-INF/mapped-services/" + annoName;
                if (this.processor.isDebugLogging()) {
                    this.print(Diagnostic.Kind.NOTE, "appending '" + configuration + "' to " + string, element);
                }
                try {
                    this.processor.getResourceManager(this.processor.getServiceDir()).getWriter(string).println(configuration);
                    this.processor.getResourceManager(this.processor.getAnalyzeDir()).getWriter(servicingClassName.replace('.', '/') + "/service.log").println(annoName + ": " + configuration);
                    continue;
                }
                catch (IOException ex) {
                    this.print(Diagnostic.Kind.ERROR, "file generation error: " + ex, element);
                    return;
                }
            }
            this.print(Diagnostic.Kind.ERROR, "annotated element '" + element + "' is not a class or interface", element);
        }
    }
}

