/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Currency;
import org.tentackle.common.LocaleProvider;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;

public class BMoney
extends BigDecimal
implements Cloneable {
    private static final long serialVersionUID = 1L;

    public BMoney(double val, int scale) {
        super(BigDecimal.valueOf(val).setScale(scale, RoundingMode.HALF_UP).unscaledValue(), scale);
    }

    public BMoney(String val, int scale) {
        super(new BigDecimal(val).setScale(scale, RoundingMode.HALF_UP).unscaledValue(), scale);
    }

    public BMoney(int scale) {
        super(new BigInteger(0, new byte[0]), scale);
    }

    public BMoney(BigInteger intVal, int scale) {
        super(intVal, scale);
    }

    public BMoney(BMoney val, int scale) {
        super(val.setScale(scale, RoundingMode.HALF_UP).unscaledValue(), scale);
    }

    public BMoney(BigDecimal val) {
        super(val.unscaledValue(), val.scale());
    }

    public BMoney() {
        this(Currency.getInstance(LocaleProvider.getInstance().getCurrentLocale()).getDefaultFractionDigits());
    }

    public BMoney clone() {
        try {
            return (BMoney)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new TentackleRuntimeException(ex);
        }
    }

    public boolean isNegative() {
        return this.signum() < 0;
    }

    public boolean isPositive() {
        return this.signum() > 0;
    }

    public boolean isZero() {
        return this.signum() == 0;
    }

    public BMoney add(BMoney val) {
        return new BMoney(this.unscaledValue().add(this.alignScale(val).unscaledValue()), this.scale());
    }

    public BMoney subtract(BMoney val) {
        return new BMoney(this.unscaledValue().subtract(this.alignScale(val).unscaledValue()), this.scale());
    }

    public BMoney multiply(double val) {
        return new BMoney(this.doubleValue() * val, this.scale());
    }

    public double divide(BMoney val) {
        return this.doubleValue() / val.doubleValue();
    }

    public BMoney divide(double val) {
        return new BMoney(this.doubleValue() / val, this.scale());
    }

    public BMoney invert() {
        return new BMoney(this.unscaledValue().negate(), this.scale());
    }

    public BMoney absolute() {
        return this.isNegative() ? this.invert() : this;
    }

    public BMoney smallestPositive() {
        return new BMoney(new BigDecimal(new BigInteger(new byte[]{1})).movePointLeft(this.scale()));
    }

    public String toWords() {
        String digits = this.setScale(0, RoundingMode.DOWN).toString();
        int len = digits.length();
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < len; ++i) {
            char c = digits.charAt(i);
            if (!Character.isDigit(c)) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            buf.append(StringHelper.digitToString(Character.valueOf(c)));
        }
        return buf.toString();
    }

    protected BMoney alignScale(BMoney val) {
        return val.scale() == this.scale() ? val : new BMoney(val.unscaledValue(), this.scale());
    }
}

