/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tentackle.common.Path;

public interface PathFactory<P extends Path<P, E>, E> {
    public P create(List<E> var1, List<P> var2);

    public P create(List<E> var1, P var2);

    default public List<P> merge(List<P> paths) {
        ArrayList<Object> consolidatedPaths = new ArrayList<Object>();
        LinkedHashMap<Object, List> pathMap = new LinkedHashMap<Object, List>();
        for (Path path : paths) {
            List elements = path.getElements();
            if (elements.isEmpty()) {
                consolidatedPaths.add(path);
                continue;
            }
            Object element = elements.get(0);
            List pathList = pathMap.computeIfAbsent(element, k -> new ArrayList());
            pathList.add(path);
        }
        for (Map.Entry entry : pathMap.entrySet()) {
            List pathList = (List)entry.getValue();
            if (pathList.size() == 1) {
                consolidatedPaths.add((Path)pathList.get(0));
                continue;
            }
            ArrayList elements = new ArrayList();
            elements.add(entry.getKey());
            List contPaths = new ArrayList();
            for (Path path : pathList) {
                ArrayList pathElements = new ArrayList(path.getElements());
                if (pathElements.isEmpty()) continue;
                pathElements.remove(0);
                if (pathElements.isEmpty()) {
                    contPaths.addAll(path.getPaths());
                    continue;
                }
                contPaths.add(this.create((List<E>)pathElements, (P)path.getPaths()));
            }
            Object leadPath = (contPaths = this.merge(contPaths)).size() == 1 ? this.create(elements, (Path)contPaths.get(0)) : this.create((List<E>)elements, (P)contPaths);
            consolidatedPaths.add(leadPath);
        }
        return consolidatedPaths;
    }
}

