/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.jlink;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.tentackle.maven.plugin.jlink.ArtifactCreator;
import org.tentackle.maven.plugin.jlink.JLinkMojo;
import org.tentackle.maven.plugin.jlink.JPackageMojo;

public class DefaultArtifactCreator
implements ArtifactCreator {
    private static final String[] INSTALLER_EXTENSIONS = new String[]{".deb", ".rpm", ".exe", ".msi", ".pkg", ".dmg"};

    @Override
    public void createAndAttachArtifact(JLinkMojo mojo) throws MojoExecutionException {
        mojo.getProjectHelper().attachArtifact(mojo.getMavenProject(), "zip", mojo.getClassifier(), mojo.createZipFile(mojo.getImageDirectory(), mojo.getFinalName() + "-" + mojo.getImageDirectory().getName()));
    }

    @Override
    public void processApplicationImage(JPackageMojo mojo, File imageDir) throws MojoExecutionException {
    }

    @Override
    public void attachInstallers(JPackageMojo mojo, long minTime) throws MojoExecutionException {
        File targetDir = new File(mojo.getMavenProject().getBuild().getDirectory());
        String[] names = targetDir.list((dir, name) -> {
            String fileName = name.toLowerCase();
            for (String extension : INSTALLER_EXTENSIONS) {
                File file;
                if (!fileName.endsWith(extension) || !(file = new File(targetDir, fileName)).isFile() || file.lastModified() <= minTime) continue;
                return true;
            }
            return false;
        });
        if (names != null) {
            for (String name2 : names) {
                int ndx = name2.lastIndexOf(46);
                if (ndx < 0) continue;
                mojo.getProjectHelper().attachArtifact(mojo.getMavenProject(), name2.substring(ndx + 1), mojo.getClassifier(), new File(targetDir, name2));
            }
        }
    }

    @Override
    public void createAndAttachArtifact(JPackageMojo mojo, File appImageDir) throws MojoExecutionException {
        mojo.getProjectHelper().attachArtifact(mojo.getMavenProject(), "zip", mojo.getClassifier() + "-pkg", mojo.createZipFile(appImageDir, mojo.getFinalName() + "-" + mojo.getPackageDirectory().getName()));
    }
}

