/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.fullhalf;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.terasoluna.gfw.common.fullhalf.FullHalfPair;
import org.terasoluna.gfw.common.fullhalf.FullHalfPairs;

public final class FullHalfConverter {
    private final Map<String, FullHalfPair> fullwidthMap;
    private final Map<String, FullHalfPair> halfwidthMap;
    private final FullHalfPairs.AppendablePredicate predicate;

    public FullHalfConverter(FullHalfPairs pairs) {
        if (pairs == null) {
            throw new IllegalArgumentException("pairs must not be null.");
        }
        Set<FullHalfPair> pairSet = pairs.pairs();
        HashMap<String, FullHalfPair> f = new HashMap<String, FullHalfPair>();
        HashMap<String, FullHalfPair> h = new HashMap<String, FullHalfPair>();
        for (FullHalfPair pair : pairSet) {
            if (!f.containsKey(pair.fullwidth())) {
                f.put(pair.fullwidth(), pair);
            }
            if (h.containsKey(pair.halfwidth())) continue;
            h.put(pair.halfwidth(), pair);
        }
        this.fullwidthMap = Collections.unmodifiableMap(f);
        this.halfwidthMap = Collections.unmodifiableMap(h);
        this.predicate = pairs.predicate();
    }

    public String toHalfwidth(String fullwidth) {
        if (fullwidth == null || fullwidth.isEmpty()) {
            return fullwidth;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < fullwidth.length(); ++i) {
            String s = String.valueOf(fullwidth.charAt(i));
            builder.append(this.halfwidth(s));
        }
        return builder.toString();
    }

    public String toFullwidth(String halfwidth) {
        if (halfwidth == null || halfwidth.isEmpty()) {
            return halfwidth;
        }
        StringBuilder builder = new StringBuilder();
        LinkedList<String> buffer = new LinkedList<String>();
        for (int i = 0; i < halfwidth.length(); ++i) {
            char c = halfwidth.charAt(i);
            String s = String.valueOf(c);
            if (buffer.isEmpty()) {
                buffer.add(s);
                continue;
            }
            String prev = (String)buffer.poll();
            if (this.predicate.isAppendable(c)) {
                FullHalfPair pair = this.halfwidthMap.get(prev + s);
                if (pair != null) {
                    builder.append(pair.fullwidth());
                    continue;
                }
                builder.append(this.fullwidth(prev));
                builder.append(this.fullwidth(s));
                continue;
            }
            builder.append(this.fullwidth(prev));
            buffer.add(s);
        }
        if (!buffer.isEmpty()) {
            builder.append(this.fullwidth((String)buffer.poll()));
        }
        return builder.toString();
    }

    private String fullwidth(String s) {
        FullHalfPair pair = this.halfwidthMap.get(s);
        if (pair != null) {
            return pair.fullwidth();
        }
        return s;
    }

    private String halfwidth(String s) {
        FullHalfPair pair = this.fullwidthMap.get(s);
        if (pair != null) {
            return pair.halfwidth();
        }
        return s;
    }
}

