/*
 * Decompiled with CFR 0.152.
 */
package org.terasoluna.gfw.common.fullhalf;

import java.io.Serializable;

public final class FullHalfPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fullwidth;
    private final String halfwidth;

    public FullHalfPair(String fullwidth, String halfwidth) {
        if (fullwidth == null || fullwidth.length() != 1) {
            throw new IllegalArgumentException("fullwidth must be 1 length string (fullwidth = " + fullwidth + ")");
        }
        if (halfwidth == null || halfwidth.length() != 1 && halfwidth.length() != 2) {
            throw new IllegalArgumentException("halfwidth must be 1 or 2 length string (halfwidth = " + halfwidth + ")");
        }
        this.fullwidth = fullwidth;
        this.halfwidth = halfwidth;
    }

    public String fullwidth() {
        return this.fullwidth;
    }

    public String halfwidth() {
        return this.halfwidth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullHalfPair that = (FullHalfPair)o;
        if (!this.fullwidth.equals(that.fullwidth)) {
            return false;
        }
        return this.halfwidth.equals(that.halfwidth);
    }

    public int hashCode() {
        int result = this.fullwidth.hashCode();
        result = 31 * result + this.halfwidth.hashCode();
        return result;
    }
}

