/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.call;

import java.util.NoSuchElementException;
import org.terracotta.management.context.Context;

public final class ContextualReturn<T> {
    private static final Object NO_RESULT = new Object();
    private final T value;
    private final Context context;

    private ContextualReturn(Context context, T value) {
        this.value = value;
        this.context = context;
    }

    public boolean hasValue() {
        return this.value != NO_RESULT;
    }

    public T getValue() throws NoSuchElementException {
        if (!this.hasValue()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public Context getContext() {
        return this.context;
    }

    public static <T> ContextualReturn<T> of(Context context, T result) {
        return new ContextualReturn<T>(context, result);
    }

    public static <T> ContextualReturn<T> empty(Context context) {
        return new ContextualReturn<Object>(Context.empty(), NO_RESULT);
    }
}

