/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.capabilities.descriptors;

import java.util.List;
import org.terracotta.management.capabilities.descriptors.Descriptor;

public class CallDescriptor
implements Descriptor {
    private final String name;
    private final String returnType;
    private final List<Parameter> parameters;

    public CallDescriptor(String name, String returnType, List<Parameter> parameters) {
        this.name = name;
        this.returnType = returnType;
        this.parameters = parameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallDescriptor that = (CallDescriptor)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null) {
            return false;
        }
        return !(this.parameters == null ? that.parameters != null : !((Object)this.parameters).equals(that.parameters));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? ((Object)this.parameters).hashCode() : 0);
        return result;
    }

    public static class Parameter {
        private final String name;
        private final String type;

        public Parameter(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (this.name != null ? !this.name.equals(parameter.name) : parameter.name != null) {
                return false;
            }
            return !(this.type == null ? parameter.type != null : !this.type.equals(parameter.type));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

