/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.stats;

import org.terracotta.management.stats.Statistic;

public abstract class AbstractStatistic<V, U>
implements Statistic<V, U> {
    private final String name;
    private final V value;
    private final U unit;

    public AbstractStatistic(String name, V value, U unit) {
        this.name = name;
        this.value = value;
        this.unit = unit;
    }

    @Override
    public U getUnit() {
        return this.unit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public String toString() {
        return "{name='" + this.getName() + '\'' + ", value=" + this.getValue() + ", unit=" + this.getUnit() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStatistic that = (AbstractStatistic)o;
        return this.name.equals(that.name) && this.value.equals(that.value) && this.unit.equals(that.unit);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.unit.hashCode();
        return result;
    }
}

