/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.stats;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.terracotta.management.context.Context;
import org.terracotta.management.stats.Statistic;

public final class ContextualStatistics
implements Iterable<Statistic<?, ?>> {
    private final Map<String, Statistic<?, ?>> statistics;
    private final Context context;

    public ContextualStatistics(Context context, Map<String, Statistic<?, ?>> statistics) {
        this.statistics = statistics;
        this.context = context;
    }

    public int size() {
        return this.statistics.size();
    }

    public boolean isEmpty() {
        return this.statistics.isEmpty();
    }

    @Override
    public Iterator<Statistic<?, ?>> iterator() {
        return this.statistics.values().iterator();
    }

    public Map<String, Statistic<?, ?>> getStatistics() {
        return this.statistics;
    }

    public <T extends Statistic<?, ?>> T getStatistic(Class<T> type) throws NoSuchElementException {
        Map<String, T> filtered = this.getStatistics(type);
        if (filtered.size() != 1) {
            throw new NoSuchElementException(type.getName());
        }
        return (T)((Statistic)filtered.values().iterator().next());
    }

    public <T extends Statistic<?, ?>> T getStatistic(Class<T> type, String name) throws NoSuchElementException {
        Map<String, T> filtered = this.getStatistics(type);
        for (Statistic statistic : filtered.values()) {
            if (!statistic.getName().equals(name)) continue;
            return (T)statistic;
        }
        throw new NoSuchElementException(name + ":" + type.getName());
    }

    public <T extends Statistic<?, ?>> Map<String, T> getStatistics(Class<T> type) {
        LinkedHashMap<String, T> filtered = new LinkedHashMap<String, T>();
        for (Map.Entry<String, Statistic<?, ?>> entry : this.statistics.entrySet()) {
            if (!type.isInstance(entry.getValue())) continue;
            filtered.put(entry.getKey(), type.cast(entry.getValue()));
        }
        return filtered;
    }

    public Context getContext() {
        return this.context;
    }
}

