/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.runtime;

import java.io.IOException;
import java.util.Locale;
import org.terracotta.utilities.test.io.WindowsSpecialFolder;

public class Os {
    private Os() {
    }

    public static String getOsName() {
        return System.getProperty("os.name", "unknown").toLowerCase(Locale.ROOT);
    }

    public static String getOsArch() {
        return System.getProperty("os.arch", "unknown");
    }

    public static String platform() {
        String osname = Os.getOsName();
        if (osname.startsWith("windows")) {
            return "win32";
        }
        if (osname.startsWith("linux")) {
            return "linux";
        }
        if (osname.startsWith("sunos")) {
            return "solaris";
        }
        if (osname.startsWith("mac") || osname.startsWith("darwin")) {
            return "mac";
        }
        if (osname.startsWith("aix")) {
            return "aix";
        }
        return "generic";
    }

    public static boolean isWindows() {
        return Os.getOsName().contains("windows");
    }

    public static boolean isLinux() {
        return Os.getOsName().contains("linux");
    }

    public static boolean isUnix() {
        String os = Os.getOsName();
        if (os.contains("sunos") || os.contains("linux")) {
            return true;
        }
        return Os.isMac() && System.getProperty("os.version", "").startsWith("10.");
    }

    public static boolean isMac() {
        String os = Os.getOsName();
        return os.startsWith("mac") || os.startsWith("darwin");
    }

    public static boolean isSolaris() {
        return Os.getOsName().contains("sunos");
    }

    public static boolean isAix() {
        return Os.getOsName().contains("aix");
    }

    public static boolean isArchx86() {
        return Os.getOsArch().toLowerCase().contains("x86");
    }

    public static boolean isHpux() {
        return Os.getOsName().startsWith("hp-ux");
    }

    public static String findWindowsSystemRoot() {
        if (!Os.isWindows()) {
            return null;
        }
        try {
            return WindowsSpecialFolder.SYSTEM.get().toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

