/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.utilities.exec.Shell;
import org.terracotta.utilities.test.net.EphemeralPorts;
import org.terracotta.utilities.test.runtime.Os;

public final class ReservedPorts {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReservedPorts.class);

    static List<EphemeralPorts.Range> getRange() {
        if (Os.isLinux()) {
            return new Linux().getRanges();
        }
        if (Os.isMac()) {
            return Collections.emptyList();
        }
        if (Os.isWindows()) {
            return new Windows().getRanges();
        }
        if (Os.isSolaris()) {
            return Collections.emptyList();
        }
        if (Os.isAix()) {
            return Collections.emptyList();
        }
        if (Os.isHpux()) {
            return Collections.emptyList();
        }
        throw new AssertionError((Object)("No support for this OS: " + Os.getOsName()));
    }

    public static void main(String[] args) {
        ReservedPorts.getRange().forEach(System.out::println);
    }

    private static class Windows {
        private Windows() {
        }

        List<EphemeralPorts.Range> getRanges() {
            ArrayList<EphemeralPorts.Range> excludedRanges = new ArrayList<EphemeralPorts.Range>();
            try {
                File netshExe = new File(Os.findWindowsSystemRoot(), "netsh.exe");
                Object[] cmd = new String[]{netshExe.getAbsolutePath(), "interface", "ipv4", "show", "excludedportrange", "protocol=tcp"};
                Shell.Result result = Shell.execute((Charset)Shell.Encoding.CHARSET, (String[])cmd);
                if (result.exitCode() != 0) {
                    LOGGER.warn("Cannot determine excluded ports: command {} failed; rc={}:%n    {}", new Object[]{Arrays.toString(cmd), result.exitCode(), String.join((CharSequence)"\n    ", (Iterable<? extends CharSequence>)result)});
                    return Collections.emptyList();
                }
                Pattern pattern = Pattern.compile("^\\s+(\\d+)\\s+(\\d+).*");
                for (String line : result) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    excludedRanges.add(new EphemeralPorts.Range(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Unable to excluded port ranges", (Throwable)e);
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(excludedRanges);
        }
    }

    private static class Linux {
        private static final String SOURCE = "/proc/sys/net/ipv4/ip_local_reserved_ports";

        private Linux() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<EphemeralPorts.Range> getRanges() {
            ArrayList<EphemeralPorts.Range> reservedRanges = new ArrayList<EphemeralPorts.Range>();
            File rangeSource = new File(SOURCE);
            if (!rangeSource.exists() || !rangeSource.canRead()) {
                LOGGER.warn("Cannot access \"{}\"; cannot determine reserved ports", (Object)SOURCE);
                return Collections.emptyList();
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(SOURCE, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
                String reservations = reader.readLine();
                if (reservations == null || reservations.isEmpty()) {
                    LOGGER.debug("No reserved port ranges read from {}", (Object)SOURCE);
                    List<EphemeralPorts.Range> list = Collections.emptyList();
                    return list;
                }
                Pattern rangePattern = Pattern.compile("(\\d+)(?:-(\\d+))?");
                for (String token : Pattern.compile(",").split(reservations)) {
                    Matcher rangeMatch = rangePattern.matcher(token);
                    if (rangeMatch.matches()) {
                        int lower = Integer.parseInt(rangeMatch.group(1));
                        int upper = rangeMatch.group(2) == null ? lower : Integer.parseInt(rangeMatch.group(2));
                        reservedRanges.add(new EphemeralPorts.Range(lower, upper));
                        continue;
                    }
                    LOGGER.warn("Failed to match '{}' from {}", (Object)token, (Object)SOURCE);
                }
                if (!reservedRanges.isEmpty()) return Collections.unmodifiableList(reservedRanges);
                LOGGER.debug("No reserved port ranges parsed from {}", (Object)SOURCE);
                return Collections.unmodifiableList(reservedRanges);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to determine reserved ports", (Throwable)e);
                return Collections.emptyList();
            }
        }
    }
}

