/*
 * Decompiled with CFR 0.152.
 */
package org.terrakube.client.spring.autoconfigure;

import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.terrakube.client.TerrakubeClient;
import org.terrakube.client.dex.DexCredentialAuthentication;
import org.terrakube.client.spring.autoconfigure.RestClientProperties;

@Configuration
@EnableConfigurationProperties(value={RestClientProperties.class})
@ConditionalOnMissingBean(value={TerrakubeClient.class})
public class RestClientAutoConfiguration {
    @Autowired
    private RestClientProperties restClientProperties;

    @Bean
    public TerrakubeClient restClient(RestClientProperties restClientProperties) {
        TerrakubeClient restClient = null;
        if (restClientProperties.isEnableSecurity()) {
            DexCredentialAuthentication clientCredentialAuthentication = new DexCredentialAuthentication(restClientProperties.getSecretKey(), restClientProperties.getCredentialType());
            okhttp3.OkHttpClient customHttpClient = new OkHttpClient.Builder().authenticator((Authenticator)clientCredentialAuthentication).addInterceptor((Interceptor)clientCredentialAuthentication).build();
            restClient = (TerrakubeClient)Feign.builder().encoder((Encoder)new GsonEncoder()).decoder((Decoder)new GsonDecoder()).client((Client)new OkHttpClient(customHttpClient)).target(TerrakubeClient.class, restClientProperties.getUrl());
        } else {
            restClient = (TerrakubeClient)Feign.builder().encoder((Encoder)new GsonEncoder()).decoder((Decoder)new GsonDecoder()).logger((Logger)new Slf4jLogger()).client((Client)new OkHttpClient()).logLevel(Logger.Level.FULL).target(TerrakubeClient.class, restClientProperties.getUrl());
        }
        return restClient;
    }
}

