/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.config;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import com.wix.mysql.distribution.Version;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.test4j.module.database.IDataSourceScript;
import org.test4j.module.database.proxy.DataSourceDefaultCreator;
import org.test4j.module.database.proxy.IDataSourceCreator;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.config.Config;
import org.test4j.tools.config.ConfigHelper;

public interface DbConfig
extends Config {
    public static final DbConfig DEFAULT = new DbConfig(){};

    public static DbConfig instance() {
        if (ConfigHelper.getConfig() instanceof DbConfig) {
            return (DbConfig)ConfigHelper.getConfig();
        }
        return DEFAULT;
    }

    default public List<String> dataSourceList() {
        String list = ConfigHelper.getString((String)"db.dataSources");
        return Arrays.stream(list.split("[,;]")).filter(item -> !StringHelper.isBlank((String)item)).map(String::trim).collect(Collectors.toList());
    }

    default public String defaultDataSource() {
        String dataSource = ConfigHelper.getString((String)"db.default");
        return StringHelper.isBlank((String)dataSource) ? "dataSource" : dataSource.trim();
    }

    default public DbType defaultDbType() {
        String type = this.defaultDataSource();
        if (StringHelper.isBlank((String)type)) {
            return DbType.H2;
        }
        return this.dbType(type);
    }

    default public DbType dbType(String dataSource) {
        String propKey = String.format("db.%s.type", dataSource);
        String value = ConfigHelper.getString((String)propKey, (String)"");
        return this.databaseType(value);
    }

    default public DbType databaseType(String type) {
        if (StringHelper.isBlank((String)type)) {
            return DbConfig.instance().defaultDbType();
        }
        DbType dbType = DbType.dbType((String)type);
        if (dbType == null) {
            throw new RuntimeException("unknown database type:" + type);
        }
        return dbType;
    }

    default public String dbDriver(String dataSource) {
        return DataSourceDefaultCreator.getDataSourceConfig(dataSource, "driver");
    }

    default public String dbUsername(String dataSource) {
        return DataSourceDefaultCreator.getDataSourceConfig(dataSource, "username");
    }

    default public String dbPassword(String dataSource) {
        return DataSourceDefaultCreator.getDataSourceConfig(dataSource, "password");
    }

    default public String dbSchema(String dataSource) {
        return DataSourceDefaultCreator.getDataSourceConfig(dataSource, "schema");
    }

    default public String dbUrl(String dataSource) {
        return DataSourceDefaultCreator.getDataSourceConfig(dataSource, "url");
    }

    default public IDataSourceCreator dbCreator(String dataSource) {
        String propKey = String.format("db.%s.creator", dataSource);
        String factory = ConfigHelper.getString((String)propKey, (String)"");
        try {
            if (StringHelper.notBlank((String)factory)) {
                return (IDataSourceCreator)ClazzHelper.createInstanceOfType((String)factory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DataSourceDefaultCreator();
    }

    default public String[] dbScript(String dataSource) {
        String propKey = String.format("db.%s.script", dataSource);
        String value = ConfigHelper.getString((String)propKey, (String)"");
        if (StringHelper.isBlank((String)value)) {
            return new String[0];
        }
        return value.split("[;,]");
    }

    default public IDataSourceScript dbScriptFactory(String dataSource) {
        String propKey = String.format("db.%s.script.factory", dataSource);
        String value = ConfigHelper.getString((String)propKey, (String)"");
        if (StringHelper.isBlank((String)value)) {
            return null;
        }
        Object instance = ClazzHelper.createInstanceOfType((String)value);
        if (instance instanceof IDataSourceScript) {
            return (IDataSourceScript)instance;
        }
        throw new RuntimeException("the script class should implement interface: " + IDataSourceScript.class.getName());
    }

    default public boolean isAllowing(String dataSourceName) {
        String onlyTest = ConfigHelper.getString((String)"database.only.test");
        if ("TRUE".equalsIgnoreCase(onlyTest)) {
            return true;
        }
        DbType type = this.dbType(dataSourceName);
        if (type.feature.isMemory()) {
            return true;
        }
        String url = this.dbUrl(dataSourceName);
        if (url.contains("127.0.0.1") || url.toUpperCase().contains("LOCALHOST")) {
            return true;
        }
        String schemaName = this.dbSchema(dataSourceName);
        return schemaName.endsWith("TEST") || schemaName.startsWith("TEST");
    }

    default public int embeddedMysqlPort() {
        return Integer.getInteger("mysql.embedded.port", 23306);
    }

    default public Version embeddedMysqlVersion() {
        try {
            String version = ConfigHelper.getString((String)"mysql.embedded.version", (String)"v8_0_17");
            return Version.valueOf((String)version);
        }
        catch (Exception e) {
            return Version.v8_0_17;
        }
    }

    default public boolean embeddedMysqlEnable() {
        return ConfigHelper.getBoolean((String)"mysql.embedded.enabled", (boolean)true);
    }

    default public String embeddedMysqlRemoteHost() {
        return ConfigHelper.getString((String)"mysql.embedded.remote.host", (String)"");
    }

    default public int embeddedMysqlRemotePort() {
        return Integer.getInteger("mysql.embedded.remote.port", 8080);
    }
}

