/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.datagen;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.test4j.module.database.datagen.TableData;
import org.test4j.tools.IKit;
import org.test4j.tools.commons.ResourceHelper;
import org.test4j.tools.datagen.DataMap;
import org.test4j.tools.datagen.IDataMap;

public class TableMap
extends LinkedHashMap<String, TableData> {
    public static TableMap fromText(String json) {
        return (TableMap)IKit.json.toObject(json, TableMap.class);
    }

    public static TableMap fromFile(Class packClass, String fileName) {
        try {
            String text = ResourceHelper.readFromFile((Class)packClass, (String)fileName);
            return TableMap.fromText(text);
        }
        catch (Throwable e) {
            throw new RuntimeException("read json text error:" + e.getMessage(), e);
        }
    }

    public TableMap initWith(IDataMap init, boolean skip, String ... tables) {
        Set all = tables == null || tables.length == 0 ? this.keySet() : Arrays.stream(tables).collect(Collectors.toSet());
        for (String table : all) {
            if (this.containsKey(table)) {
                ((TableData)this.get(table)).setInit(init);
                continue;
            }
            if (skip) continue;
            this.put(table, new TableData().setInit(init));
        }
        return this;
    }

    public IDataMap dataMap(String table) {
        return ((TableData)this.get(table)).findDataMap();
    }

    public TableMap apply(Consumer<DataMap> consumer, boolean skip, String ... tables) {
        Set all = tables == null || tables.length == 0 ? this.keySet() : Arrays.stream(tables).collect(Collectors.toSet());
        for (String table : all) {
            TableData data = (TableData)this.get(table);
            if (data == null && skip) continue;
            assert (data != null);
            consumer.accept((DataMap)data.findDataMap());
        }
        return this;
    }

    @Override
    public String toString() {
        return "TableMap()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableMap)) {
            return false;
        }
        TableMap other = (TableMap)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableMap;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

