/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.enviroment;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.test4j.Logger;
import org.test4j.module.database.config.DbConfig;
import org.test4j.module.database.enviroment.DBEnvironment;
import org.test4j.module.database.enviroment.types.DefaultEnvironment;
import org.test4j.module.database.enviroment.types.MySqlEnvironment;
import org.test4j.module.database.enviroment.types.OracleEnvironment;

public final class DBEnvironmentFactory {
    private static final Map<String, DBEnvironment> environments = new HashMap<String, DBEnvironment>();

    private static DBEnvironment createDBEnvironment(String dataSourceName) {
        DbType dbType = DbConfig.instance().dbType(dataSourceName);
        DBEnvironment environment = DBEnvironmentFactory.newInstance(dbType, dataSourceName);
        environments.put(dataSourceName, environment);
        return environment;
    }

    private static DBEnvironment newInstance(DbType dbType, String dataSourceName) {
        if (dbType == null) {
            throw new RuntimeException("DatabaseType can't be null.");
        }
        switch (dbType) {
            case MYSQL: 
            case H2: 
            case MARIADB: {
                return new MySqlEnvironment(dataSourceName);
            }
            case ORACLE: {
                return new OracleEnvironment(dataSourceName);
            }
        }
        return new DefaultEnvironment(dataSourceName);
    }

    public static DBEnvironment getDefaultDBEnvironment() {
        String defaultDataSource = DbConfig.instance().defaultDataSource();
        return DBEnvironmentFactory.getDBEnvironment(defaultDataSource);
    }

    public static DBEnvironment getDBEnvironment(String dataSourceName) {
        return Optional.ofNullable(environments.get(dataSourceName)).orElseGet(() -> DBEnvironmentFactory.createDBEnvironment(dataSourceName));
    }

    public static void closeDBEnvironment() {
        for (Map.Entry<String, DBEnvironment> environment : environments.entrySet()) {
            try {
                environment.getValue().commit();
            }
            catch (Throwable e) {
                Logger.warn((Object)("commit transactional error: " + e.getMessage()), (Throwable[])new Throwable[0]);
            }
        }
    }
}

