/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.enviroment.typesmap;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.TIMESTAMP;
import org.test4j.module.database.enviroment.typesmap.AbstractTypeMap;
import org.test4j.tools.commons.DateHelper;

public class OracleTypeMap
extends AbstractTypeMap {
    public static Map<String, Class> types = new HashMap<String, Class>(){
        {
            this.put("oracle.sql.CLOB", String.class);
            this.put("oracle.sql.BLOB", BLOB.class);
            this.put("oracle.sql.TIMESTAMP", TIMESTAMP.class);
        }
    };

    @Override
    public Object toObjectByType(String input, Class javaType) {
        if (javaType == TIMESTAMP.class) {
            long time = DateHelper.parse((String)input).getTime();
            Timestamp stamp = new Timestamp(time);
            return new TIMESTAMP(stamp);
        }
        if (javaType == CLOB.class || javaType == BLOB.class) {
            return this.getStream(input);
        }
        return input;
    }

    @Override
    protected Class getJavaTypeByName(String typeName) {
        Class type = types.get(typeName);
        return type == null ? String.class : type;
    }

    @Override
    protected Object getDefaultValue(Class javaType) {
        if (javaType == TIMESTAMP.class) {
            Date now = new Date();
            Timestamp stamp = new Timestamp(now.getTime());
            return new TIMESTAMP(stamp);
        }
        if (javaType == CLOB.class || javaType == BLOB.class) {
            return this.getStream("stream");
        }
        return null;
    }
}

