/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.operator;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.test4j.exception.Exceptions;
import org.test4j.module.database.enviroment.DBEnvironment;
import org.test4j.module.database.operator.ISqlSet;
import org.test4j.module.database.script.SqlRunner;

public class SqlSet
implements ISqlSet {
    private final List<String> list = new ArrayList<String>();

    public void sql(String sql) {
        this.list.add(sql);
    }

    public void readFrom(DBEnvironment env, String filename) {
        try {
            SqlRunner.executeFromFile(env, filename);
        }
        catch (Exception e) {
            throw Exceptions.wrapWithRuntimeException((Throwable)e);
        }
    }

    public void readFrom(DBEnvironment env, File file) {
        try {
            SqlRunner.executeFromStream(env, new FileInputStream(file));
        }
        catch (Exception e) {
            throw Exceptions.wrapWithRuntimeException((Throwable)e);
        }
    }

    public void readFrom(DBEnvironment env, InputStream stream) {
        try {
            SqlRunner.executeFromStream(env, stream);
        }
        catch (Exception e) {
            throw Exceptions.wrapWithRuntimeException((Throwable)e);
        }
    }

    @Override
    public void execute(DBEnvironment env) {
        for (String sql : this.list) {
            SqlRunner.execute(env, sql);
        }
    }
}

